#
# papyrus-menus.tcl  -- standard menus definitions
#
# This file is part of PAPyRUS
#
# Author: Carlos Nunes
# Date:  6/4/96
#




# Function : Load_Style_Menus
# 
# Invoked at the init of Papyrus, this function defines the standard styles.
#

proc Load_Fonts {} {

#
# "Times" family
# 
   
AddFont -family "Times" -style "normal"	\
	-x11 "-adobe-times-medium-r-normal--*-*-*-*-*-*-iso8859-1"	\
	-ps "Times-Roman"

AddFont -family "Times" -style "bold"	\
	-x11 "-adobe-times-bold-r-normal--*-*-*-*-*-*-iso8859-1"	\
	-ps "Times-Bold"

AddFont -family "Times" -style "italic"	\
	-x11 "-adobe-times-medium-i-normal--*-*-*-*-*-*-iso8859-1"	\
	-ps "Times-Italic"

AddFont -family "Times" -style "bold_italic"	\
	-x11 "-adobe-times-bold-i-normal--*-*-*-*-*-*-iso8859-1"	\
	-ps "Times-BoldItalic"

#
# "Helvetica" family
# 

AddFont -family "Helvetica" -style "normal" \
	-x11 "-adobe-helvetica-medium-r-normal--*-*-*-*-*-*-iso8859-1"	\
	-ps "Helvetica"

AddFont -family "Helvetica" -style "bold" \
	-x11 "-adobe-helvetica-bold-r-normal--*-*-*-*-*-*-iso8859-1"	\
	-ps "Helvetica-Bold"

AddFont -family "Helvetica" -style "italic" \
	-x11 "-adobe-helvetica-medium-o-normal--*-*-*-*-*-*-iso8859-1"	\
	-ps "Helvetica-Oblique"

AddFont -family "Helvetica" -style "bold_italic" \
	-x11 "-adobe-helvetica-bold-o-normal--*-*-*-*-*-*-iso8859-1"	\
	-ps "Helvetica-BoldOblique"

#
# "Courier" family
# 

AddFont -family "Courier" -style "normal" \
	-x11 "-adobe-courier-medium-r-normal--*-*-*-*-*-*-iso8859-1"	\
	-ps "Courier"

AddFont -family "Courier" -style "bold" \
	-x11 "-adobe-courier-bold-r-normal--*-*-*-*-*-*-iso8859-1"	\
	-ps "Courier-Bold"

AddFont -family "Courier" -style "italic" \
	-x11 "-adobe-courier-medium-o-normal--*-*-*-*-*-*-iso8859-1"	\
	-ps "Courier-Oblique"

AddFont -family "Courier" -style "bold_italic" \
	-x11 "-adobe-courier-bold-o-normal--*-*-*-*-*-*-iso8859-1"	\
	-ps "Courier-BoldOblique"

#
# "Symbol" family
# 

AddFont -family "Symbol" -style "normal"	\
	-x11 "-adobe-symbol-medium-r-normal--*-*-*-*-*-*-adobe-fontspecific" \
	-ps "Symbol"

Add_Family_Entry "Courier"
Add_Family_Entry "Helvetica"
Add_Family_Entry "Times"
Add_Family_Entry "Symbol"
}



# Function : Load_Style_Menus
# 
# Invoked at the init of Papyrus, this function defines the standard styles.
#

proc Load_Default_Styles {} {

    set normal_font  { Times      normal      10 }
    set title1_font  { Helvetica  bold        14 }
    set title2_font  { Helvetica  bold_italic 12 }
    set title3_font  { Helvetica  normal      12 }
    set listing_font { Courier    normal      10 }

    AddStyle -name "Normal"  -font $normal_font  -align "center" \
	    -margins {0  0 0 0} -fline 0.5c

    AddStyle -name "Titre1"  -font $title1_font  -align "left" -margins {12p 3p 0 0}
    AddStyle -name "Titre2"  -font $title2_font  -base "Titre1"
    AddStyle -name "Titre3"  -font $title3_font  -base "Titre1"

    AddStyle -name "Listing" -font $listing_font -base "Normal" -fline 0 -next "Listing"

    AddStyle -name "Liste1"  -base "Normal" -margins {0 0 0.5c 0} \
	    -fline -0.5c -tag 168 -next "Liste1"
    AddStyle -name "Liste2"  -base "Normal" -margins {0 0 1c 0} \
	    -fline -0.5c -tag 183 -next "Liste2"
    AddStyle -name "Liste3"  -base "Normal" -margins {0 0 1.5c 0} \
	    -fline -0.5c -tag 174 -next "Liste3"
}


#
# Function : Load_Default_OptionMenus
# 
# Invoked at the init of Papyrus, this function defines some standard option menus.
#


proc Load_Default_OptionMenus {} {

    #
    # Defines the zoom optionMenu
    #

    foreach zoom {50  75  100  150  200  300} {
	Add_Zoom_Entry $zoom
    }

    #
    # Defines the font family optionMenu
    #

#    foreach family {Courier Helvetica "new century schoolbook" times} {
#	Add_Family_Entry $family
#    }

    #
    # Defines the font size optionMenu
    #

    foreach size {8 9 10 11 12 14 16 18 20 22 24 26 28 36 48 72} {
	Add_Size_Entry $size
    }
    
}
