# 
# papyrus-keys.tcl  --
# 
#       This file contains the Tcl commands for standart
#       keys bindings definitions.
# 
#  Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
# 
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 



#
# Function : Load_Default_Keys
# 
# Loads the default keys for Papyrus.
# This function is invoked at the initialisation of Papyrus
#

proc Load_Default_Keys {} {

    SetKey "space"     { NewWord }               "Insere un espace"
    SetKey "C-space"   { InsertCharacter " " }   "Insere un espace insecable"
    SetKey "Return"    { NewParagraph }          "Cree un nouveau paragraphe"
    SetKey "KP_Enter"  { NewParagraph }          "Cree un nouveau paragraphe"
    
    SetKey "Delete"    { DeleteCharacterAfter }  "Efface le caractere suivant"
    SetKey "BackSpace" { DeleteCharacterBefore } "Efface le caractere precedent"
    
    SetKey "Left"      { MoveCursorLeft }        "Deplace le curseur vers la gauche"
    SetKey "Right"     { MoveCursorRight }       "Deplace le curseur vers la droite"
    SetKey "Up"        { MoveCursorUp }          "Deplace le curseur vers le haut"
    SetKey "Down"      { MoveCursorDown }        "Deplace le curseur vers le bas"
    
    SetKey "C-Left"    { MoveCursorPreviousWord} "Deplace le curseur a la fin du mot precedent"
    SetKey "C-Right"   { MoveCursorNextWord }    "Deplace le curseur au debut du mot suivant"

    SetKey "C-L"   { MoveCursorPreviousWord} "Deplace le curseur a la fin du mot precedent"
    SetKey "C-R"   { MoveCursorNextWord }    "Deplace le curseur au debut du mot suivant"
    SetKey "Home"  { MoveCursorHome }        "Deplace le curseur au debut du document"
    SetKey "XK_End"   { MoveCursorEnd }         "Deplace le curseur a la fin du document"
}
