#
# emacs-keys.tcl  -- keyboard input definitions for emacs shortcuts
#
# This file is part of PAPyRUS
#
# Author: Carlos Nunes
# Date:  4/4/96
#

#
# Function : Load_Emacs_Bindings
# 
# Set the shorcuts definitions for emacs bindings
#

proc Load_Emacs_Bindings {} {

    SetKey {C-b}  { MoveCursorLeft  }           "Move cursor left"
    SetKey {C-f}  { MoveCursorRight }           "Move cursor right"
    SetKey {C-p}  { MoveCursorUp    }           "Move cursor up"
    SetKey {C-n}  { MoveCursorDown  }           "Move cursor down"

    SetKey {M-f}  { MoveCursorNextWord     }   "Move cursor to next word"
    SetKey {M-b}  { MoveCursorPreviousWord }   "Move cursor to previous word"

    SetKey {C-a}  { MoveCursorBeginLine }      "Move cursor to the beginning of line"
    SetKey {C-e}  { MoveCursorEndLine   }      "Move cursor to the end of line"

    SetKey {C-d}  { DeleteCharacterAfter }     "Delete the character after the cursor"

}