/* 
 * util.h --
 *
 *      This file contains the declaration of the functions from
 *      the util.cc file.
 *
 * Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef UTIL_H
#define UTIL_H

#include "page.h"
#include "line.h"
#include "paragraph.h"
#include "shape.h"
#include "thePosition.h"


extern void  MergeParagraphs(Line *, Paragraph *);
extern Line *First_of_Para_In_Page(Paragraph *, Page *);
extern Line *First_of_Para(Line *);
extern Line *Last_of_Para(Line *);

extern char *Alignment_to_String(StyleAlignType);
extern int   String_to_Alignment(char *);

extern int   String_to_FontStyle(char *);
extern char *FontStyle_to_String(FontStyle);

extern void Shape_Restore_Attributes(Shape *, Attributes *, Attributes *);
extern void Update_Shape_Attributes(ThePosition &);
extern void Add_Empty_WordSegment(void);
extern void Sort_Attributes(Paragraph *, Attributes *);

extern char *Time_to_String(void);

extern BOOL Check_Font_Attributes(AttrType, void *);

extern void Check_Attributes(void);

#endif
