/* 
 * papyrus.h --
 *
 *      This file contains the declaration and the definitions
 *      of the 'Papyrus' class.
 *
 * Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef PAPYRUS_H
#define PAPYRUS_H


#include "display.h"
#include "FontManager/fontManager.h"
#include "StyleManager/styleManager.h"


/*
 * Units measures allowed
 */
typedef enum { CENTIMETERS, INCHES, MILLIMETERS, POINTS } UnitType;


/*
 * The Papyrus class derives from the XDisplay, FontManager and
 * StyleManager classes.
 */


class Papyrus : public XDisplay, public FontManager, public StyleManager {

private:

  BOOL     _doc_mask;     // Tell if the document mask is displayed
  UnitType     _unit;     // Gives the unit used for dimensions


public:
  
  inline Papyrus(Display *disp) : XDisplay(disp), FontManager(disp) {}
  ~Papyrus();
  

  inline void mask_doc(BOOL b)              { _doc_mask = b; }
  inline BOOL mask_doc(void)         const  { return _doc_mask; }

  inline void set_unit(UnitType u)          { _unit = u; }
  inline UnitType get_unit(void)     const  { return _unit; }

};


extern Papyrus *papyrus;


#endif
