/* 
 * global.h --
 *
 *      This file contains the declaration of some globals
 *      declarations uses in all (praticly) the files.
 *
 * Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef GLOBALS_H
#define GLOBALS_H


#ifdef FALSE
#undef FALSE
#endif

#ifdef TRUE
#undef TRUE
#endif

#ifdef BOOL
#undef BOOL
#endif


typedef enum { FALSE=0, TRUE=1 } BOOL;

#define ZOOM(size) ((int)((size)*zoom))
#define UNZOOM(size) ((int)((size)/zoom))

extern float zoom;

#ifndef HAVE_GUI
#define WIDTH_SCALE  1.00
#define HEIGHT_SCALE 1.00
#else
#define WIDTH_SCALE  1
#define HEIGHT_SCALE 1
#endif

#ifdef __cplusplus
extern "C" {
  extern char *strdup(const char *);
}
#else
  extern char *strdup(const char *);
#endif


#endif
