/* 
 * events.cc --
 *
 *      This file contains fonctions used to process X events.
 *
 * Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */


extern "C" {
#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/keysym.h>    /* For the keys codes */

#ifndef HAVE_GUI
 #include "../misc/shortcuts.h"
#endif

#include "../tcl/mytcl.h"
}


#include "papyrus.h"
#include "frame.h"
#include "../tcl/commands.h"
#include "document.h"
#include "wordSegment.h"


extern struct ThePosition current;
extern Tcl_Interp *theInterp;



/*
 *----------------------------------------------------------------------
 *
 * buttonPress_handler --
 *
 *      This method is used to process mouse button pressed events.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

#ifdef HAVE_GUI
void
buttonPress_handler(Widget widget, XtPointer closure, XEvent *event, Boolean *b) {
  
  char cmd[32];
  Page *pagePtr;
  int i;
  Window win;

  /* To prevent warning compilation */
  pagePtr = NULL;

  /*
   * Convert the current window to a page object
   */
  win = XtWindow(widget);
  for(i=0; i<current.doc->get_children_num(); i++)
    if( ((Page *)current.doc->get_child(i))->get_win() == win ) {
      pagePtr = (Page *)current.doc->get_child(i);
      break;
    }
  
  /*
   * Set the cursor at the beginnning of the page
   */
  current.shape = (Shape *)pagePtr->get_child(0)->get_child(0)->get_child(0);
  current.pos = 0;

  Tcl_Eval(theInterp, "SetCursor off");
  sprintf(cmd, "MoveCursorXY %d %d", event->xbutton.x, event->xbutton.y);
  Tcl_MyEval(cmd);
  Tcl_Eval(theInterp, "SetCursor on");
}



/*
 *----------------------------------------------------------------------
 *
 * expose_handler --
 *
 *      This method is used to process expose events.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
expose_handler(Widget widget, XtPointer closure, XEvent *event, Boolean *b) {

  XExposeEvent *xev = (XExposeEvent *)event;
  int pos;
  Frame *frame;
  Page *page = (Page *)closure;
  
  page->set_to_redraw(REDRAW_ME);

  frame = page->xy_to_frame(0, xev->y, pos);
  frame = ((WordSegment *)frame)->get_line_parent();
  frame->set_to_redraw(REDRAW_PAGE);

  page->draw_frame(0, 0);
  if( page == current.shape->get_page_parent() )
    current.doc->clear_cursor(current.shape, current.pos);

  XSync(XtDisplay(widget), False);
}


#else


/*
 *----------------------------------------------------------------------
 *
 * My_AppMainLoop --
 *
 *      This method is the events main loop of the application, when
 *      there's no GUI specified at compilation time.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
My_AppMainLoop(void) {

  XEvent event;
  char string[2];
  KeySym keysym;
  char cmd[32];


  XSelectInput(papyrus->get_disp(), papyrus->get_win(),
               ButtonPressMask | KeyPressMask);

  for(;;) {
    
    Tcl_Eval(theInterp, "SetCursor on");
    XNextEvent(papyrus->get_disp(), &event);
    Tcl_Eval(theInterp, "SetCursor off");

    switch( event.type ) {

    case ButtonPress:
      Tcl_Eval(theInterp, "SetCursor off");
      sprintf(cmd, "MoveCursorXY %d %d", event.xbutton.x, event.xbutton.y);
      Tcl_Eval(theInterp, cmd);
      Tcl_Eval(theInterp, "SetCursor on");
      break;

    case KeyPress:
      XLookupString((XKeyPressedEvent*)&event, string, 1, &keysym, NULL);
      keyPress_handler(&event);
    }
  }
}



/*
 *----------------------------------------------------------------------
 *
 * My_Display_Init --
 *
 *      This method initializes the display and the tree object, when
 *      there's no GUI specified at compilation time.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
My_Display_Init(void) {
  
  Display *disp;

  disp = XOpenDisplay(":0.0");
  
  if( disp == NULL ) {
    fprintf(stderr, "My_Display_Init: Can't open display\n");
    exit(1);
  }
  papyrus =  new Papyrus(disp);
}


#endif
