/* 
 * cursor.cc --
 *
 *      This file contains the definitions of the 'MyCursor' class
 *      methods.
 *
 * Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include "cursor.h"
#include "papyrus.h"



/*
 *----------------------------------------------------------------------
 *
 * MyCursor --
 *
 *      This procedure is invoked every time a MyCursor object is created.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      The datas class are initialized.
 *
 *----------------------------------------------------------------------
 */

MyCursor::MyCursor() {

  _x = 0;
  _y =0;
  _x_abs = 0;
  _x_select = 0;
  _y_select = 0;
  
  _height = 0;
}



/*
 *----------------------------------------------------------------------
 *
 * ~MyCursor --
 *
 *      This procedure is invoked every time a MyCursor object is deleted.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

MyCursor::~MyCursor() {
}


void
MyCursor::draw_cursor(Frame *frame, int offset) {

  if( has_selection() == TRUE )
    return;

  frame->frame_to_xy(_x, _y, offset);
  _height = ((Frame *)frame->get_parent()->get_parent())->get_height();

  XDrawLine(papyrus->get_disp(), papyrus->get_win(), papyrus->get_xor_gc(),
	    _x, _y, _x, _y+_height);

  XFlush(papyrus->get_disp());
}



/*
 *----------------------------------------------------------------------
 *
 * clear_cursor --
 *
 *      This function clears the cursor in the screen.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
MyCursor::clear_cursor(Frame *frame, int offset) {

  if( has_selection() == TRUE )
    return;

  XDrawLine(papyrus->get_disp(), papyrus->get_win(),
	    papyrus->get_xor_gc(), _x, _y, _x, _y+_height);
  return;
}
