/* 
 * ascii_output.cc --
 *
 *      This file contains all the methods used to translate the
 *      document into ASCII.
 *
 * Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include "frame.h"
#include "line.h"
#include "wordSegment.h"
#include "image.h"
#include "output.h"



/*
 *----------------------------------------------------------------------
 *
 * WordSegment::output_ascii --
 *
 *      This function generates the contents of the 'WordSegment'
 *      object into ASCII.
 *
 * Results:
 *      A standard Tcl result.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

int
WordSegment::output_ascii(void) {
  
  if( _children_num > 0 )
    OUTS(_children);
  return TCL_OK;
}



/*
 *----------------------------------------------------------------------
 *
 * Image::output_ascii --
 *
 *      This function generates the contents of the 'Image' object
 *      into ASCII.
 *
 * Results:
 *      None is produced, only returns TCL_OK.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

int
Image::output_ascii(void) {
  return TCL_OK;
}



/*
 *----------------------------------------------------------------------
 *
 * Line::output_ascii --
 *
 *      This function generates the contents of the 'Line' object
 *      into ASCII.
 *
 * Results:
 *      A standard Tcl result.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

int
Line::output_ascii(void) {
  
  int i;

  for(i=0; i<_children_num-1; i++) {
    ((Frame *)_children[i])->output_ascii();
    OUTS(" ");
  }
  if( i < _children_num )
    ((Frame *)_children[i])->output_ascii();
  OUTS("\n");
  return TCL_OK;
}



/*
 *----------------------------------------------------------------------
 *
 * Frame::output_ascii --
 *
 *      This function generates the contents of the 'Frame' object
 *      into ASCII. This function is used by all the object which
 *      have no output_ascii method.
 *
 * Results:
 *      A standard Tcl result.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

int
Frame::output_ascii(void) {
  
  int i;

  for(i=0; i<_children_num; i++)
    ((Frame *)_children[i])->output_ascii();
  return TCL_OK;
}
