/* 
 * menus.cc --
 *
 *      This file contains functions that creates the menu bar.
 *
 * Copyright (C) 1996  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include <stdio.h>

#include <Xm/RowColumn.h>
#include <Xm/MenuShell.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleBG.h>

#include <Xm/SeparatoG.h>
#include <Xm/CascadeBG.h>

#include "callbacks.h"

/*
 * Allowed menu entry type
 */
typedef enum { PUSH_BUTTON, TOGGLE_BUTTON, SEPARATOR, NONE } ButtonType;

/*
 * This structure defines an entry in the menu.
 */
typedef struct {
  ButtonType           type;
  XtCallbackProc   callback;
  XtPointer      clientdata;
}MenuPane;


/*
 * 'File' menu.
 */
MenuPane menuFile[11] = {
  { PUSH_BUTTON,  menu_p0_b0_CB, NULL },
  { PUSH_BUTTON,  menu_p0_b1_CB, NULL },
  { PUSH_BUTTON,  menu_p0_b2_CB, NULL },
  { SEPARATOR,    NULL, NULL          },
  { PUSH_BUTTON,  menu_p0_b4_CB, NULL },
  { PUSH_BUTTON,  menu_p0_b4_CB, NULL },
  { SEPARATOR,    NULL, NULL          },
  { PUSH_BUTTON,  menu_p0_b5_CB, NULL },
  { SEPARATOR,    NULL, NULL          },
  { PUSH_BUTTON,  menu_p0_b6_CB, NULL },
  { NONE, NULL, NULL }
};


/*
 * 'Edit' menu.
 */
MenuPane menuEdit[12] = {
  { PUSH_BUTTON,  NULL, NULL },
  { PUSH_BUTTON,  NULL, NULL },
  { PUSH_BUTTON,  NULL, NULL },
  { SEPARATOR,    NULL, NULL },
  { PUSH_BUTTON,  NULL, NULL },
  { PUSH_BUTTON,  NULL, NULL },
  { PUSH_BUTTON,  NULL, NULL },
  { SEPARATOR,    NULL, NULL },
  { PUSH_BUTTON,  NULL, NULL },
  { PUSH_BUTTON,  NULL, NULL },
  { PUSH_BUTTON,  NULL, NULL },
  { NONE, NULL, NULL }
};


/*
 * 'Format' menu.
 */
MenuPane menuFormat[4] = {
  { PUSH_BUTTON,  menu_p2_b0_CB, (XtPointer)3 },
  { PUSH_BUTTON,  menu_p2_b0_CB, (XtPointer)2 },
  { PUSH_BUTTON,  menu_p2_b0_CB, (XtPointer)1 },
/*
  { SEPARATOR,    NULL, NULL },
  { PUSH_BUTTON,  NULL, NULL },
  { PUSH_BUTTON,  NULL, NULL },
  { PUSH_BUTTON,  NULL, NULL },
  { PUSH_BUTTON,  NULL, NULL },
  { PUSH_BUTTON,  NULL, NULL },
  { PUSH_BUTTON,  NULL, NULL },
*/
  { NONE, NULL, NULL }
};


/*
 * 'Tools' menu.
 */
MenuPane menuTools[8] = {
  { PUSH_BUTTON,  menu_p3_b0_CB, NULL },
  { PUSH_BUTTON,  menu_p3_b1_CB, NULL },
  { SEPARATOR,    NULL, NULL },
  { PUSH_BUTTON,  menu_p3_b3_CB, NULL },
  { PUSH_BUTTON,  NULL, NULL },
  { SEPARATOR,    NULL, NULL },
  { PUSH_BUTTON,  NULL, NULL },
  { NONE, NULL, NULL }
};


/*
 * 'Windows' menu.
 */
MenuPane menuWin[9] = {
  { TOGGLE_BUTTON,  menu_p4_b0_CB, NULL },
  { TOGGLE_BUTTON,  menu_p4_b1_CB, NULL },
  { TOGGLE_BUTTON,  NULL, NULL          },
  { TOGGLE_BUTTON,  menu_p4_b3_CB, NULL },
  { TOGGLE_BUTTON,  menu_p4_b4_CB, NULL },
  { TOGGLE_BUTTON,  menu_p4_b5_CB, NULL },
  { TOGGLE_BUTTON,  menu_p4_b6_CB, NULL },
  { SEPARATOR,    NULL, NULL          },
  { NONE, NULL, NULL }
};


/*
 * 'Help' menu.
 */
MenuPane menuHelp[2] = {
/*
  { PUSH_BUTTON,  NULL, NULL },
  { PUSH_BUTTON,  NULL, NULL },
  { PUSH_BUTTON,  NULL, NULL },
  { SEPARATOR,    NULL, NULL },
*/
  { PUSH_BUTTON,  menu_p5_b3_CB, NULL },
  { NONE, NULL, NULL }
};


/*
 * Menu bar.
 */
MenuPane *menuBar[] = { menuFile, menuEdit, menuFormat, menuTools, menuWin, menuHelp, NULL };



/*
 *----------------------------------------------------------------------
 *
 * GUI_CreateMenus --
 *
 *      This function creates the menu bar and the contents.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

Widget
GUI_CreateMenus(Widget mainWindow) {

  int i, j;
  char string[32];
  Widget main_menu, menu_shell, menu_pane, menu_top, menu_button;

  /* To prevent warnings at compilation time */
  menu_top = NULL;

  main_menu = XtVaCreateManagedWidget("main_menu",
				      xmRowColumnWidgetClass,
				      mainWindow,
				      XmNrowColumnType, XmMENU_BAR,
				      NULL );
  for(i=0; menuBar[i] != NULL; i++) {
    sprintf(string, "menu_p%d_shell", i);
    menu_shell = XtVaCreatePopupShell (string,
				       xmMenuShellWidgetClass, main_menu,
				       XmNwidth, 1,
				       XmNheight, 1,
				       XmNallowShellResize, True,
				       XmNoverrideRedirect, True,
				       NULL );
    
    sprintf(string, "menu_p%d", i);
    menu_pane = XtVaCreateWidget(string,
				 xmRowColumnWidgetClass,
				 menu_shell,
				 XmNrowColumnType, XmMENU_PULLDOWN,
				 XmNtearOffModel, XmTEAR_OFF_ENABLED,
				 NULL );

    for(j=0; menuBar[i][j].type != NONE; j++) {
      sprintf(string, "menu_p%d_b%d", i, j);    
      menu_button = XtVaCreateManagedWidget(string,
					    (menuBar[i][j].type == PUSH_BUTTON ) ?
					    xmPushButtonGadgetClass :
					    (menuBar[i][j].type == TOGGLE_BUTTON ) ?
					    xmToggleButtonGadgetClass :
					    xmSeparatorGadgetClass,
					    menu_pane,
					    NULL);
      if( menuBar[i][j].callback != NULL )
	XtAddCallback(menu_button,
		      (menuBar[i][j].type == PUSH_BUTTON ) ?
		      XmNactivateCallback :
		      XmNvalueChangedCallback,
		      (XtCallbackProc)menuBar[i][j].callback,
		      (XtPointer)menuBar[i][j].clientdata);
    }
    sprintf(string, "menu_top_p%d", i);
    menu_top = XtVaCreateManagedWidget(string,
				       xmCascadeButtonGadgetClass, main_menu,
				       XmNsubMenuId, menu_pane,
				       NULL );
  }
  XtVaSetValues(main_menu, XmNmenuHelpWidget, menu_top, NULL);

  XtVaSetValues(XtNameToWidget(mainWindow, "*menu_p4_b0"), XmNset, True, NULL);
  XtVaSetValues(XtNameToWidget(mainWindow, "*menu_p4_b1"), XmNset, True, NULL);
  XtVaSetValues(XtNameToWidget(mainWindow, "*menu_p4_b3"), XmNset, True, NULL);
  XtVaSetValues(XtNameToWidget(mainWindow, "*menu_p4_b5"), XmNset, True, NULL);

  return main_menu;
}
