/* 
 * tclGet.h --
 *
 *      This file contains the declaration of the functions from
 *      the TclGet.c file.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef TCLGET_H
#define TCLGET_H

#include <tcl.h>

#include "../kernel/StyleManager/styleItem.h"
#include "../kernel/attributes.h"
#include "../kernel/papyrus.h"


extern int Tcl_GetFontStyle(Tcl_Interp *, char *, FontStyle &);
extern int Tcl_GetVoffset(Tcl_Interp *, char *, VOffsetType &);
extern int Tcl_GetAlignment(Tcl_Interp *, char *, StyleAlignType &);
extern int Tcl_GetFont(Tcl_Interp *, char *, FontItem *&);
extern int Tcl_GetMargins(Tcl_Interp *, char *, int *);
extern int Tcl_GetPixels(Tcl_Interp *, char *, int *);
extern int Tcl_GetChannelForWrite(Tcl_Interp *, char *, Tcl_Channel &);
#endif
