/* 
 * shortcuts.h --
 *
 *      This file contains the declaration of the functions from
 *      the shortcuts.c file.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef SHORTCUTS_H
#define SHORTCUTS_H


#define PARTIAL (void *)1


typedef struct _shortcut {

  int           len;
  char        *keys;
  char        *info;
  char         *cmd;
  struct _shortcut *next;

}ShortCut;


extern ShortCut *GKeys;



ShortCut *is_global_key(char *);

#ifdef HAVE_GUI
void keyPress_handler(Widget, XtPointer, XEvent *, Boolean *);
#else
void keyPress_handler(XEvent *);
#endif

int display_all_shortcuts(void);


#endif
