/* 
 * env.c --
 *
 *      This file contains fonctions which manage several environment
 *      variables used by PAPyRUS.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */


#include <stdlib.h>

#include "env.h"
#include "../kernel/globals.h"


char *papyrus_dir;


/*
 *----------------------------------------------------------------------
 *
 * Get_Environment --
 *
 *      This function is invoked to set several environment variables
 *      used by PAPyRUS.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      The variable declared in 'env.h' are updated.
 *
 *----------------------------------------------------------------------
 */

void
Get_Environment(void) {
  
  papyrus_dir = getenv("PAPYRUS_DIR");
  if( papyrus_dir == NULL )
    papyrus_dir = strdup("/usr/local/lib/Papyrus");
}
