# 
# spell.tcl  --
# 
#       This file contains the procedures for document spelling.
# 
#  Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
# 
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 



proc Ispell_Open {dicts} {
    global fd

    set name [concat "|ispell -a -d" $dicts]
    set fd [open $name r+]
    # skips the message line
    gets $fd result    
}


proc Ispell_Close {} {
    global fd
    
    catch close $fd
}



proc Ispell_Buffer {} {
    global fd

    while { 1 } {

	set str [WordOutput]
	
	if { [regexp {^[!~@#%&*-]} $str] == 0 } {
	    puts $fd $str
	    flush $fd
	    
	    gets $fd result
	    
	    if { [string length $result] > 0 } {
		
		# flush the outup of ispell because it inserts a '\n'
		gets $fd
		
		set label [lindex $result 0]
		
		if { $label == "#" } {
		    return $result
		}
		if { $label == "&" } {
		    return $result
		}
	    }
	}
	if [ catch { MoveCursorNextWord } ] {
	    Ispell_Close
	    return "*"
	}
    }
}



proc Ispell_Document {} {

    # go to the beginning of the document
    catch MoveCursorBeginLine
    while { [catch MoveCursorUp] == 0 } { }

    # start the ispell process
    Ispell_Open "francais"

    # start the spelling of the document
    return [Ispell_Buffer]
}



proc Ispell_Ignore {} {
 
    if { [catch MoveCursorNextWord] == 0 } {
	return [Ispell_Buffer]
    }
    Ispell_Close
    return "*"
}
