# 
# qwerty-accents.tcl  --
# 
#       This file contains the keyboard input definitions for ISO 8859/1.
# 
#  Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
# 
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 



#
# Function : Load_Qwerty_Accents
# 
# Set the keyboard shortcuts for ISO 8859/1.
#

proc Load_Qwerty_Accents {} {

    SetKey "/ !"     { InsertCharacter \xa1 }   "Insert exclamdown"
    SetKey "/ c"     { InsertCharacter \xa2 }   "Insert cent"
    SetKey "/ l"     { InsertCharacter \xa3 }   "Insert sterling"
    SetKey "/ *"     { InsertCharacter \xa4 }   "Insert currency"
    SetKey "/ y"     { InsertCharacter \xa5 }   "Insert yen"
    SetKey "/ |"     { InsertCharacter \xa6 }   "Insert brokenbar"
    SetKey "/ s"     { InsertCharacter \xa7 }   "Insert section"
    SetKey "\" \""   { InsertCharacter \xa8 }   "Insert diaeresis"
    SetKey "/ C"     { InsertCharacter \xa9 }   "Insert copyright"
    SetKey "_ a"     { InsertCharacter \xaa }   "Insert ordfeminine"
    SetKey "~ <"     { InsertCharacter \xab }   "Insert guillemotleft"

    SetKey "/ R"     { InsertCharacter \xae }   "Insert registered"
    SetKey "/ /"     { InsertCharacter \xb0 }   "Insert degree"
    SetKey "+ -"     { InsertCharacter \xb1 }   "Insert plusminus"
    SetKey "^ 2"     { InsertCharacter \xb2 }   "Insert twosuperior"
    SetKey "^ 3"     { InsertCharacter \xb3 }   "Insert threesuperior"
    SetKey "\' \'"   { InsertCharacter \xb4 }   "Insert grave"
    SetKey "/ u"     { InsertCharacter \xb5 }   "Insert mu"
    SetKey "/ p"     { InsertCharacter \xb6 }   "Insert 'paragraph'"
    SetKey "/ ."     { InsertCharacter \xb7 }   "Instert periodcentered"
    SetKey "/ ,"     { InsertCharacter \xb8 }   "Instert cedilla"
    SetKey "^ 1"     { InsertCharacter \xb9 }   "Insert onesuperior"
    SetKey "_ o"     { InsertCharacter \xba }   "Insert masculine"
    SetKey "~ >"     { InsertCharacter \xbb }   "Insert guillemotright"

    SetKey "1 / 4"   { InsertCharacter \xbc }   "Insert onequarter"
    SetKey "1 / 2"   { InsertCharacter \xbd }   "Insert onehalf"
    SetKey "3 / 4"   { InsertCharacter \xbe }   "Insert threequarters"
    SetKey "/ ?"     { InsertCharacter \xbf }   "Insert questiondown"
    SetKey "` A"     { InsertCharacter \xc0 }   "Insert A with a grave accent"
    SetKey "' A"     { InsertCharacter \xc1 }   "Insert A with an acute accent"
    SetKey "^ A"     { InsertCharacter \xc2 }   "Insert A with a circumflex accent"
    SetKey "~ A"     { InsertCharacter \xc3 }   "Insert A with a tilde"
    SetKey "\" A"    { InsertCharacter \xc4 }   "Insert A with a diaeresis"
    SetKey ". A"     { InsertCharacter \xc5 }   "Insert A with a ring"
    SetKey "/ E"     { InsertCharacter \xc6 }   "Insert AE"
    SetKey "~ C"     { InsertCharacter \xc7 }   "Insert C with a cidilla" 
    SetKey "` E"     { InsertCharacter \xc8 }   "Insert E with a grave accent"
    SetKey "' E"     { InsertCharacter \xc9 }   "Insert E with an acute accent"
    SetKey "^ E"     { InsertCharacter \xca }   "Insert E with a circumflex accent"
    SetKey "\" E"    { InsertCharacter \xcb }   "Insert E with a diaeresis"
    SetKey "` I"     { InsertCharacter \xcc }   "Insert I with a grave accent"
    SetKey "' I"     { InsertCharacter \xcd }   "Insert I with an acute accent"
    SetKey "^ I"     { InsertCharacter \xce }   "Insert I with a circumflex accent"
    SetKey "\" I"    { InsertCharacter \xcf }   "Insert I with a diaeresis"
    SetKey "~ D"     { InsertCharacter \xd0 }   "Insert D with a tilde"
    SetKey "~ N"     { InsertCharacter \xd1 }   "Insert N with a tilde"
    SetKey "` O"     { InsertCharacter \xd2 }   "Insert O with a grave accent"
    SetKey "' O"     { InsertCharacter \xd3 }   "Insert O with an acute accent"
    SetKey "^ O"     { InsertCharacter \xd4 }   "Insert O with a circumflex accent"
    SetKey "~ O"     { InsertCharacter \xd5 }   "Insert O with a tilde"
    SetKey "\" O"    { InsertCharacter \xd6 }   "Insert O with a diaeresis"
    SetKey "/ O"     { InsertCharacter \xd8 }   "Insert O with an oblique"
    SetKey "` U"     { InsertCharacter \xd9 }   "Insert U with a grave accent"
    SetKey "' U"     { InsertCharacter \xda }   "Insert U with an acute accent"
    SetKey "^ U"     { InsertCharacter \xdb }   "Insert U with a circumflex accent"
    SetKey "\" U"    { InsertCharacter \xdc }   "Insert U with a diaeresis"
    SetKey "' Y"     { InsertCharacter \xdd }   "Insert Y with an acute accent"
    SetKey "/ T"     { InsertCharacter \xde }   "Insert Thorn"
    SetKey "\" s"    { InsertCharacter \xdf }   "Insert ssharp"
    SetKey "` a"     { InsertCharacter \xe0 }   "Insert a with a grave accent"
    SetKey "' a"     { InsertCharacter \xe1 }   "Insert a with an acute accent"
    SetKey "^ a"     { InsertCharacter \xe2 }   "Insert a with a circumflex accent"
    SetKey "~ a"     { InsertCharacter \xe3 }   "Insert a with a tilde"
    SetKey "\" a"    { InsertCharacter \xe4 }   "Insert a with a diaeresis"
    SetKey ". a"     { InsertCharacter \xe5 }   "Insert a with a ring"
    SetKey "/ e"     { InsertCharacter \xe6 }   "Insert aE"
    SetKey "~ c"     { InsertCharacter \xe7 }   "Insert c with a cidilla"
    SetKey "` e"     { InsertCharacter \xe8 }   "Insert e with a grave accent"
    SetKey "' e"     { InsertCharacter \xe9 }   "Insert e with an acute accent"
    SetKey "^ e"     { InsertCharacter \xea }   "Insert e with a circumflex accent"
    SetKey "\" e"    { InsertCharacter \xeb }   "Insert e with a diaeresis"
    SetKey "` i"     { InsertCharacter \xec }   "Insert i with a grave accent"
    SetKey "' i"     { InsertCharacter \xed }   "Insert i with an acute accent"
    SetKey "^ i"     { InsertCharacter \xee }   "Insert i with a circumflex accent"
    SetKey "\" i"    { InsertCharacter \xef }   "Insert i with a diaeresis"
    SetKey "~ d"     { InsertCharacter \xf0 }   "Insert d with a tilde"
    SetKey "~ n"     { InsertCharacter \xf1 }   "Insert N with a tilde"
    SetKey "` o"     { InsertCharacter \xf2 }   "Insert o with a grave accent"
    SetKey "' o"     { InsertCharacter \xf3 }   "Insert o with an acute accent"
    SetKey "^ o"     { InsertCharacter \xf4 }   "Insert o with a circumflex accent"
    SetKey "~ o"     { InsertCharacter \xf5 }   "Insert o with a tilde"
    SetKey "\" o"    { InsertCharacter \xf6 }   "Insert o with a diaeresis"
    SetKey "/ o"     { InsertCharacter \xf8 }   "Insert o with an oblique"
    SetKey "` u"     { InsertCharacter \xf9 }   "Insert u with a grave accent"
    SetKey "' u"     { InsertCharacter \xfa }   "Insert u with an acute accent"
    SetKey "^ u"     { InsertCharacter \xfb }   "Insert u with a circumflex accent"
    SetKey "\" u"    { InsertCharacter \xfc }   "Insert u with a diaeresis"
    SetKey "' y"     { InsertCharacter \xfd }   "Insert y with an acute accent"
    SetKey "/ t"     { InsertCharacter \xfe }   "Insert thorn"
    SetKey "\" y"    { InsertCharacter \xff }   "Insert y with a diaeresis"
}