/* 
 * thePosition.h --
 *
 *      This file contains the declaration of the 'ThePosition' class.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef THE_POSITION
#define THE_POSITION


#include "attributes.h"

class Document;
class Shape;


typedef struct ThePosition {

  Document  *doc;    // Document object (top of the tree)
  Shape   *shape;    // Current shape   (current leaf of the tree)
  int        pos;    // Current child of the shape
    
  Attributes *attr;
};


extern struct ThePosition current;

extern void PositionSave(void);
extern void PositionSave(Document *, Shape *, int);
extern void PositionRestore(void);
extern void PositionSet(Document *, Shape *, int);
extern BOOL PositionFind_And_Replace(ThePosition &);

#endif

