/* 
 * shape.h --
 *
 *      This file contains the declaration and the definitions
 *      of the 'Shape' class.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef SHAPE_H
#define SHAPE_H

extern "C" {
#include <stdio.h>
}

#include "frame.h"
#include "line.h"
#include "page.h"
#include "attributes.h"


/*
 * Shape class derives from Frame class
 */


class Shape : public Frame {

public:
  Attributes *_attr;    // Attributes of the Shape


public:

  Shape()          { _attr = NULL; }

  virtual void alloc_offset(int) = 0;
  virtual void insert_children(Container **, int, int) = 0;
  virtual void delete_children(int, int) = 0;
  virtual void move_children(int, int, Container *, int) = 0;

  virtual void merge_container(Container *) = 0;

  virtual void can_fit(ThePosition &) = 0;
  virtual void recompute_size(BOOL = TRUE) = 0;

  virtual void draw_frame(int, int) = 0;
  virtual void frame_to_xy(int &, int &, int) = 0;
  virtual Frame *xy_to_frame(int, int, int &) = 0;

  virtual int output_ascii(void) = 0;
  virtual int output_papyrus(void) = 0;

  virtual inline const BOOL can_append(void) const = 0;
  virtual inline void *get_absolute_attr(Attributes *, AttrType) const = 0;

  inline int has_attributes(short a=~0)      const
    { return (_attr != NULL) ? _attr->has_mark(a) : 0; }

  inline void set_attributes(Attributes *a)             { _attr = a; }
  inline Attributes *get_attributes(void)    const      { return _attr; }

  inline void copy_attributes(Attributes *a)    { _attr->copy_attributes(a); }

  inline Line *get_line_parent(void) const  { return (Line *)get_parent()->get_parent();      }
  inline Page *get_page_parent(void) const  { return (Page *)get_line_parent()->get_parent(); }
  inline Paragraph *get_para(void)   const  { return get_line_parent()->get_para();           }
  virtual inline char *get_string(void)  const = 0;

};



#endif
