/* 
 * paragraph.h --
 *
 *      This file contains the declaration of the 'Paragraph' class.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef PARAGRAPH_H
#define PARAGRAPH_H

#include "StyleManager/styleItem.h"
#include "marker.h"
#include "thePosition.h"


/*
 * Paragraph class derives from Marker class.
 */


class Paragraph : public Marker {
  
private:
  
  StyleItem         *_bstyle;     /* The base style of paragraph         */
  StyleItem         *_dstyle;     /* The derived style of paragraph      */


public:

  Paragraph();
  Paragraph(Paragraph *);

  ~Paragraph();

  inline StyleItem *get_bstyle(void)       const     { return _bstyle; }
  void copy_dstyle(Paragraph *);

  inline void *query(StyleAttrType t)
    { return (has_mark(t) == 0) ?  _bstyle->get_attr(t) : _dstyle->get_attr(t); }

  void recompute(ThePosition &);
  void configure(StyleAttrType, void *);
  
  int output_papyrus(void);
  int output_ps(void);
};


#endif
