/* 
 * page.h --
 *
 *      This file contains the declaration of the 'Page' class.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef PAGE_H
#define PAGE_H

#include "document.h"
#include "line.h"

#define INTERLIGNE ZOOM(2)

/*
 * The Page class herites from Fram class.
 */


class Page : public Frame {

private:

  Window _win;      // X11 Window of the page


public:

  Page();
  ~Page();  

  Container *new_of_same_type(void);

  inline const char *type(void) const   { return "Page"; }
  void delete_children(int, int);

  void recompute_size(BOOL = TRUE);
  void can_fit(ThePosition &);
  void format_frame(void);

  inline int get_tmargin(void)      const      { return ((Document *)_parent)->get_tmargin(); }
  inline int get_bmargin(void)      const      { return ((Document *)_parent)->get_bmargin(); }
  inline int get_lmargin(void)      const      { return ((Document *)_parent)->get_lmargin(); }
  inline int get_rmargin(void)      const      { return ((Document *)_parent)->get_rmargin(); }

  inline unsigned short get_width(void)
    {return ((Frame *)_parent)->get_width() - get_lmargin() - get_rmargin();}

  inline unsigned short get_max_height(void)
    {return ((Frame *)_parent)->get_height() - get_tmargin() - get_bmargin();}
  
  void draw_frame(int, int);
  void mark_to_redraw(void);

  void frame_to_xy(int &, int &, int);
  Frame *xy_to_frame(int, int, int &);

  void clear_frame(Line *);
  void clear_frame_para(Line *);

  void redraw_para(int, int &);
  void redraw_page(int, int &);

  void debug(int=0);

  inline Window get_win(void)     const    { return _win; }
  inline void set_win(Window w)            { _win = w; }

  void draw_margins(void);

  int output_ps(void);
};



#endif
