/* 
 * marker.h --
 *
 *      This file contains the declaration and the definitions
 *      of the 'Marker' class.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef BINARY_ARRAY
#define BINARY_ARRAY


#include "globals.h"



class Marker {

private:

  int _mask;     // mask of the contents (to speedup searches)


public:

  inline Marker(void)                   { _mask = 0; }
  inline ~Marker()                      { }

  inline int  has_mark(int a=~0) const  { return _mask & a; }
  inline void add_mark(int a)           { _mask |= a;       }
  inline void set_marker(int a)         { _mask = a;        }
  inline void unset_mark(int a)         { _mask &= ~a;      }
  
};


#endif

