/* 
 * main.cc --
 *
 *      This file contains the main functions of the application.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */


extern "C" {
#include <stdio.h>

#include "globals.h"
#include "../tcl/mytcl.h"

#ifdef HAVE_GUI
 #include "../gui/mainWin.h"
#endif

extern int My_Tcl_Main(int, char **);
}


#include "papyrus.h"
#include "../misc/env.h"


#ifdef HAVE_GUI

XrmOptionDescRec Desc[] = {
  {"-visual", "*visual", XrmoptionSepArg, NULL},
  {"-depth", "*depth", XrmoptionSepArg, NULL}
};

static XtAppContext app_context;
static XtWorkProcId workProcId;

Widget toplevel;
int ac;
char **av;
Dimension appWidth, appHeight;


extern "C" {
  extern void Scale_Increment();
  extern void Intro_Message(char *);
  extern void Set_Actions(XtAppContext);
  extern void CenterDialog_CB(Widget, XtPointer, XtPointer);
  extern void GUI_CreateWelcome_Dialog();
}

#else
 #include "events.h"
#endif


BOOL interactive_flag;
Papyrus *papyrus;


/*
 *----------------------------------------------------------------------
 *
 * Init_Papyrus --
 *
 *      This method is invoked to create some features of the
 *      application when PAPyRUS starts (tcl, gui, kernel).
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

#ifdef HAVE_GUI
void
Init_Papyrus(void) {

  /*
   * The following lines prevent a bug from my X version
   * so Init_Papyrus will be called only 1 time.
   */
  static int i=0;

  if( i != 0 )
    return;
  else
    i = 1;

  
  XtRemoveWorkProc(workProcId);

  Intro_Message("Creating main GUI");
  GUI_Create();

  Intro_Message("Setting actions");
  Set_Actions(app_context);

  Intro_Message("Initializing kernel");
  papyrus = new Papyrus( XtDisplay(toplevel) );
  Scale_Increment();

  /*
   * For the moment, XDisplay isn't know, and zoom is
   * initialised by XDisplay constructor.
   */
  zoom = 1;

  Intro_Message("Starting Tcl interpreter");
  My_Tcl_Main(ac, av);
  Tcl_LinkVar(theInterp, "interactive_flag", (char *)&interactive_flag, TCL_LINK_BOOLEAN);
  Scale_Increment();

  Intro_Message("Papyrus ready");
  Scale_Increment();
  XtRealizeWidget(toplevel);
  Scale_Increment();
  XtDestroyWidget(XtNameToWidget(toplevel, "*welcome"));
}

#endif


/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *      This method is the main function of the application.
 *
 * Results:
 *      Standart C main function result.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

int
main(int argc, char **argv) {

  interactive_flag = (BOOL)TRUE;

  Get_Environment();

#ifdef HAVE_GUI
  Display *d;

  toplevel = XtVaAppInitialize(&app_context, "Papyrus",
			       Desc, XtNumber(Desc), &argc, argv,
			       NULL, NULL, NULL);

  d = XtDisplay(toplevel);
  appWidth = DisplayWidth(d, 0);
  appHeight = DisplayHeight(d, 0);

  GUI_CreateWelcome_Dialog();

  ac = argc;
  av = argv;

  workProcId = XtAppAddWorkProc(app_context, (XtWorkProc)Init_Papyrus, NULL);
  XtAppMainLoop(app_context);

#else

  My_Display_Init();

  if( My_Tcl_Main(argc, argv) != TCL_OK )
    exit(1);
  
  Tcl_LinkVar(theInterp, "interactive_flag", (char *)&interactive_flag, TCL_LINK_BOOLEAN);

  Tcl_Eval(theInterp, "NewDocument");
  
  My_AppMainLoop();

#endif

  return 0;
}
