/* 
 * line.h --
 *
 *      This file contains the declaration of the 'Line' class.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef LINE_H
#define LINE_H


#include "container.h"
#include "frame.h"
#include "paragraph.h"


/*
 * The Line class herites from the Frame class.
 */

class Line : public Frame {

private:
  
  float _x_offset;      // Inter Word spacing
  Paragraph *_para;     // Paragraph where Line is



public:

  Line(Paragraph *);
  ~Line();

  Container *new_of_same_type(void);

  inline const char *type(void)           const     { return "Line";     }

  int get_lmargin(void);
  void draw_line_tag(int, int);

  inline int get_max_width(void)
    { return ((Frame *)_parent)->get_width() - 
	get_lmargin() - (int)get_para()->query(STYLE_RIGHT_MARGIN); }

  inline void set_x_offset(float offset)            { _x_offset = offset; }
  inline float get_x_offset(void)         const     { return _x_offset;   }

  inline int get_interline(void)
    { return (int)((float)get_height() * 0.2); }

  inline int get_real_width(void)
    { return UNZOOM(get_width() + ((float)((_children_num-1) * _x_offset) - 
	   ((((Frame *)_children[_children_num-1])->get_width() == 0) ? _x_offset : 0))); }

  void recompute_size(BOOL = TRUE);

  void format_frame(void);
  void can_fit(ThePosition &, BOOL = FALSE);

  void draw_frame(int, int, BOOL = FALSE);
  void clear_frame(void);

  void debug(int=0);

  void frame_to_xy(int &, int &, int);
  Frame *xy_to_frame(int, int, int &);

  void set_para(Paragraph *p)        { _para = p;    }
  Paragraph *get_para(void)          { return _para; }

  BOOL is_last_of_para(void);
  BOOL is_first_of_para(void);
  BOOL is_in_same_para(Container *);

  int output_ascii(void);
  int output_papyrus(void);
  int output_ps(void);
};



#endif
