/* 
 * image.h --
 *
 *      This file contains the declaration of the 'Image' class.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef IMAGE_H
#define IMAGE_H

#include "shape.h"



/*
 * Image class derives from Shape class.
 */

class Image : public Shape {

private:

  char *_filename;     // Name of the image file


public:

  Image();
  ~Image();

  Container *new_of_same_type(void);

  inline const char *type(void)         const  { return "Image"; }

  inline const BOOL can_append(void)    const  { return FALSE; }

  void alloc_offset(int);
  void insert_children(Container **, int, int);
  void delete_children(int, int);
  void move_children(int, int, Container *, int);
  
  void merge_container(Container *);
  
  void can_fit(ThePosition &);
  void recompute_size(BOOL = TRUE);

  void *get_absolute_attr(Attributes *, AttrType) const;

  
  void draw_frame(int, int);
  void frame_to_xy(int &, int &, int);
  Frame *xy_to_frame(int, int, int &);
  
  void debug(int = 0);

  inline char *get_string(void)  const    { return NULL; }

  int output_ascii(void);
  int output_papyrus(void);

  int output_ps(void);
  float get_psWidth(void);
};



#endif
