/* 
 * frame.h --
 *
 *      This file contains the declaration of the 'Frame' class.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef FRAME_H
#define FRAME_H


#include "container.h"
#include "display.h"

/*
 * These defines are used to run some code in (or not)
 * interactive mode.
 */


#define CALL( code ) { BOOL old = interactive_flag; \
		       interactive_flag = FALSE;    \
		       code;                        \
		       interactive_flag = old;      \
		     }

#define ICALL( code ) { BOOL iold = interactive_flag; \
		        interactive_flag = TRUE;      \
		        code;                         \
		        interactive_flag = iold;      \
		      }

#define ITEST( code ) { if( interactive_flag == TRUE ) code; }

extern BOOL interactive_flag;


typedef enum { REDRAW_ME, REDRAW_PARA, REDRAW_PAGE, REDRAW_NONE } RedrawOrder;


typedef struct TheSize {
  unsigned short width;
  unsigned short ascent;
  unsigned short descent;
};


/*
 * The class Frame derives from the Container class
 */

class Frame : public Container {

private:

  TheSize     _size;       // Size of the Frame
  RedrawOrder _redraw;     // Tells if the Frame has to be redraw

public:

  Frame();
  virtual ~Frame();  

  inline virtual unsigned short get_width(void) { return ZOOM(_size.width);}
  inline unsigned short get_ascent(void)     { return ZOOM(_size.ascent);  }
  inline unsigned short get_descent(void)    { return ZOOM(_size.descent); }
  inline unsigned short get_height(void) {return ZOOM(_size.ascent + _size.descent);}

  inline void set_width(unsigned int w)      { _size.width  = UNZOOM(w);  }
  inline void set_ascent(unsigned int a)     { _size.ascent = UNZOOM(a);  }
  inline void set_descent(unsigned int d)    { _size.descent = UNZOOM(d); }

  void insert_children(Container **, int, int);
  void delete_children(int, int);
  Container *split_container(int);

  virtual void recompute_size(BOOL = TRUE);

  virtual void mark_to_redraw(void);

  inline virtual void set_to_redraw(RedrawOrder b)    { _redraw = b; }
  inline virtual RedrawOrder has_to_redraw(void)      { return _redraw; }

  virtual void draw_frame(int, int);
  virtual void clear_frame(void);

  virtual void frame_to_xy(int &, int &, int);
  virtual Frame *xy_to_frame(int, int, int &);

  virtual int output_ascii(void);
  virtual int output_papyrus(void);

  virtual int output_ps(void);
  virtual float get_psWidth(void);
};



#endif
