/* 
 * document.h --
 *
 *      This file contains the declaration of the 'Document' class.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef DOCUMENT_H
#define DOCUMENT_H

#include <string.h>

#include "frame.h"
#include "margin.h"
#include "cursor.h"
#include "thePosition.h"


/*
 * The Document class derives from Frame, Margin and MyCursor classes.
 */

class Document : public Frame, public Margin, public MyCursor {
  
private:

  char *_title;     // Title of the document
  char *_owner;     // Owner of the document


public:

  Document();
  Document(ThePosition &);
  ~Document();  

  inline void set_title(char *t)               { _title = strdup(t); }
  inline void set_owner(char *c)               { _owner = strdup(c); }

  inline char *get_title(void)        const    { return _title;   }
  inline char *get_owner(void)        const    { return _owner; }

  Container *new_of_same_type(void);
  inline const char *type(void)       const    { return "Document"; }

  void draw_frame(int, int);
  void recompute(ThePosition &);
  void set_width(unsigned int);

  int output_papyrus(void);
  int output_ps(void);
};



#endif
