/* 
 * container.h --
 *
 *      This file contains the declaration of the 'Container' class.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef CONTAINER_H
#define CONTAINER_H

extern "C" {
#include <stdio.h>
}

#include "globals.h"


#define LAST_POSITION -1
typedef enum { UP_DIRECTION=1, DOWN_DIRECTION=-1 };



class Container {

protected:

  Container **_children;   // Children array 
  short _children_num;     // Current children number
  short _children_max;     // Maximum children number before memory reallocation
  Container *_parent;      // Container parent
  

public:

  Container();
  virtual ~Container();  


  virtual inline const char *type(void) const                { return "Container"; }
  virtual Container *new_of_same_type(void);

  virtual void alloc_offset(int);

  inline virtual Container *get_parent(void)          const  { return _parent; }
  inline virtual int get_children_num(void)           const  { return _children_num; }

  virtual int get_offset()                            const;
  virtual inline int get_child_offset(Container *con) const  { return con->get_offset();}
    
  inline virtual Container *get_child(int num)        const
    { return _children[ (num==LAST_POSITION) ? _children_num-1 : num ]; }

  virtual void insert_children(Container **, int, int);
  virtual void delete_children(int, int);

  virtual void move_children(int, int, Container *, int);

  virtual Container *split_container(int);  
  virtual void merge_container(Container *);

  Container *get_next_same_container(Container * =NULL, int=0, int=UP_DIRECTION);
  Container *get_previous_same_container(Container * =NULL, int=0, int=UP_DIRECTION);

  inline BOOL has_same_parent(Container *c) 
    { return (c != NULL && c->get_parent() == get_parent()) ? TRUE : FALSE; }

  virtual void debug(int =0);
};



#endif
