/* 
 * attributes.h --
 *
 *      This file contains the declaration of the 'Attributes' class.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef ATTRIBUTES_H
#define ATTRIBUTES_H


#include "globals.h"
#include "marker.h"


/*
 * Attribute types for the Attributes object contents.
 */

typedef enum {
  BACKGROUND_ATTR     = 1<<0,
  FOREGROUND_ATTR     = 1<<1,
  VOFFSET_ATTR        = 1<<2,
  FONT_SIZE_ATTR      = 1<<3,
  FONT_STYLE_ATTR     = 1<<4,
  FONT_UNDERLINE_ATTR = 1<<6,
  FONT_FAMILY_ATTR    = 1<<7
} AttrType;

typedef enum {SUPERSCRIPT_VOFFSET=-1, SUBSCRIPT_VOFFSET=1} VOffsetType;
#define FONT_ATTR  (FONT_SIZE_ATTR | FONT_STYLE_ATTR | FONT_FAMILY_ATTR)


typedef struct Attribute {
  AttrType  type;
  void    *value;
  struct Attribute *next;
};



/*
 * Class Attributes derives from class Marker.
 */


class Attributes : public Marker {

private:

  Attribute  *_attr;     // List of attrributes


public:

  Attributes();
  ~Attributes();

  void add_attr(AttrType, void *);
  void del_attr(AttrType);

  /*
   * Be Carreful the following function is not protected, ie 'query_attr' may
   * return NULL, so '->value' will crash.
   */
  inline void *get_attr(AttrType t)            { return query_attr(t)->value; }

  Attribute *query_attr(AttrType);

  int operator==(Attributes &);
  int operator!=(Attributes &);
  Attributes *operator=(const Attributes &);

  inline Attribute *get_attributes(void)   const  { return _attr; }

  void copy_attributes(Attributes *);
  void delete_attributes(void);
};



#endif
