/* 
 * styleItem.h --
 *
 *      This file contains the declaration of the 'StyleItem' class.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef STYLE_ITEM
#define STYLE_ITEM


#include "../FontManager/fontFamily.h"
#include "../margin.h"

/*
 * Allowed alignment types
 */
typedef enum { STYLE_ALIGN_LEFT,   STYLE_ALIGN_RIGHT,
	       STYLE_ALIGN_CENTER, STYLE_ALIGN_FULL } StyleAlignType;

/*
 * Allowed list types
 */
typedef enum { NOT_LIST, UNNUMBERED_LIST, NUMBERED_LIST } StyleListType;

/*
 * Allowed style attributes types.
 */

typedef enum {
  STYLE_NAME          = 1<<0,
  STYLE_ALIGNMENT     = 1<<1,
  STYLE_FLINE_MARGIN  = 1<<2,
  STYLE_BOTTOM_MARGIN = 1<<3,
  STYLE_TOP_MARGIN    = 1<<4,
  STYLE_LEFT_MARGIN   = 1<<5,
  STYLE_RIGHT_MARGIN  = 1<<6,
  STYLE_TAG           = 1<<7,
  STYLE_POINTER       = 1<<8,
  STYLE_NEXT_STYLE    = 1<<9,
  STYLE_FONT          = 1<<10
} StyleAttrType;
  

#define STYLE_MARGINS (STYLE_TOP_MARGIN | STYLE_BOTTOM_MARGIN | \
		       STYLE_LEFT_MARGIN | STYLE_RIGHT_MARGIN)


/*
 * The class StyleItem class is derived from the Margin class.
 */

class StyleItem : public Margin {
  
private:
  
  char               *_name;     /* Name of the style      */
  FontItem           *_font;     /* Font of the style      */
  StyleAlignType _alignment;     /* Alignment of the style */
  unsigned int       _fline;     /* First line margin      */
  int                  _tag;     /* Tag of the style       */
  char             *_nstyle;     /* Style name to apply on the next paragraph */

  StyleItem         *_next;      /* Next style in the chained list     */
  StyleItem         *_prev;      /* Previous style in the chained list */


public:

  StyleItem();
  ~StyleItem();

  void *get_attr(StyleAttrType);
  void set_attr(StyleAttrType, void *);

  inline StyleItem *get_next(void)       const    { return _next;  }
  inline void set_next(StyleItem *n)              { _next = n; }

  inline StyleItem *get_prev(void)       const    { return _prev;  }
  inline void set_prev(StyleItem *n)              { _prev = n; }
};



#endif
