/* 
 * fontManager.h --
 *
 *      This file contains the declaration of the 'FontManager' class.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef FONT_MANAGER_H
#define FONT_MANAGER_H

extern "C" {
#include <X11/Xlib.h>
}

#include <tcl.h>
#include "fontFamily.h"



class FontManager {

private:

  Display       *_disp;           /* X11 Display */
  Tcl_HashTable  _tablePtr[4];    /* Hash tables for FontFamily (1 for each style) */
  Tcl_HashSearch _search;         /* Used only for searches */


public:

  FontManager(Display *);
  ~FontManager(void);  


  FontFamily *add_font(char *, FontStyle, char *, char *);
  void del_font(char *, FontStyle);

  FontItem *get_font(char *, FontStyle, int);
  FontFamily *query_font(char *, FontStyle);

  FontFamily *get_first(FontStyle);
  FontFamily *get_next();

  inline void resize_fonts(float) {}
};


#endif
