/* 
 * widgets.h --
 *
 *      This file contains the declaration of the functions from
 *      the widgets.c file.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef WIDGETS_H
#define WIDGETS_H

#include "../kernel/globals.h"

/*
 * Allowed field entry type.
 */
typedef enum { NORMAL_FIELD, PHONE_FIELD, UPPERCASE_FIELD, INTERGER_FIELD, PASSWORD_FIELD } FIELD_TYPE;


extern Widget GUI_CreateNoteBook(Widget);
extern Widget GUI_CreateComboBox(Widget);

extern Widget GUI_CreateOptionMenu(Widget, unsigned int, char *, XtCallbackProc);
extern void   GUI_Add_OptionMenuEntry(char *, char *, char *);
extern void   GUI_Delete_OptionMenuEntry(char *, char *);

extern void GUI_CreateIconBar(Widget, unsigned int);
extern Widget GUI_CreateFieldItem(Widget, FIELD_TYPE,unsigned int, const char *, int);
extern Widget GUI_CreateFileNameField(Widget, unsigned int, const char *,
				      XtCallbackProc, int);
extern Widget GUI_CreateBalloon(Widget);
extern Widget GUI_CreateFileSelectionDialog(char *, XtCallbackProc);

extern Widget GUI_CreateMainDrawing(Widget, Widget);
extern Widget GUI_CreateMainMessage(Widget);

extern Widget GUI_CreateNewDocument(void);
extern Widget GUI_CreateNewPage(int, Dimension, Dimension);

extern void GUI_Set_QuestionMsg(char *, XtCallbackProc);

extern void Create_DocumentParamsPage(Widget);
extern void Create_ParagraphParamsPage(Widget);
extern void Create_CharParamsPage(Widget);
extern void Create_PrintDialog(Widget);

extern void GUI_RealizeDialog(Widget);
extern void GUI_MakePageVisible(Display *, Window, int, int);

extern void GUI_Add_ErrorMessage(char *);
extern void GUI_Set_OMEntry(char *, char *);

extern void init_XFuncs(Widget);
extern void GUI_SetCursor(Widget);
extern void GUI_ResetCursor(Widget);

extern Widget balloon;

#endif
