/* 
 * modify_text.cc --
 *
 *      This file contains all the functions used for parsing
 *      text in the Field Entries.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include <Xm/TextF.h>
#include <Xm/Text.h>
#include <Xm/LabelG.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <ctype.h>

#include <Xm/Frame.h>

#include "widgets.h"


void field_check_phone(),  field_check_allcaps(), field_check_zip(),
     field_check_passwd(), field_value_changed(), field_traverse();
char *passwd;


/*
 *----------------------------------------------------------------------
 *
 * field_traverse --
 *
 *      This function looks for the text in the Field Entry, and 
 *      process traversal so the next field has the focus.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
field_traverse(Widget text_w, XtPointer client_data, XtPointer call_data) {

  /*  char *label = (char *) client_data; */
  
  char *string = XmTextGetString(text_w);
/*  printf ("%s %s\n", label, string); */
  XtFree (string);
  XmProcessTraversal(text_w, XmTRAVERSE_NEXT_TAB_GROUP);
}



/*
 *----------------------------------------------------------------------
 *
 * field_value_changed --
 *
 *      This function is called when value is changed in a Field
 *      Entry.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
field_value_changed(Widget text_w, XtPointer client_data, XtPointer call_data) {

  XmTextSetInsertionPosition(text_w, XmTextGetLastPosition (text_w));
}



/*
 *----------------------------------------------------------------------
 *
 * field_check_phone --
 *
 *      This function checks for a phone number input.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
field_check_phone(Widget text_w, XtPointer client_data, XtPointer call_data) {

  char c;
  int len = XmTextGetLastPosition (text_w);
  XmTextVerifyCallbackStruct *cbs = (XmTextVerifyCallbackStruct *) call_data;
  

  if (cbs->reason == XmCR_ACTIVATE) {
    if (len == 12) {
      char *string = XmTextGetString (text_w);
      XtFree (string);
      XmProcessTraversal (text_w, XmTRAVERSE_NEXT_TAB_GROUP);
    }
    return;
  }
  
  /* no backspacing or typing in the middle of string */
  if (cbs->currInsert < len) {
    cbs->doit = False;
    return;
  }
  
  if (cbs->text->length == 0) {  /* backspace */
    if (cbs->startPos == 3 || cbs->startPos == 7)
      cbs->startPos--;       /* delete the hyphen too */
    return;
  }
  
  if (cbs->text->length > 1) { /* don't allow clipboard copies */
    cbs->doit = False;
    return;
  }
  
  /* don't allow non-digits or let the input exceed 12 chars */
  if (!isdigit (c = cbs->text->ptr[0]) || len >= 12)
    cbs->doit = False;
  else if (len == 2 || len == 6) {
    cbs->text->ptr = XtRealloc (cbs->text->ptr, 2);
    cbs->text->length = 2;
    cbs->text->ptr[0] = c;
    cbs->text->ptr[1] = '-';
  }
}



/*
 *----------------------------------------------------------------------
 *
 * field_check_allcaps --
 *
 *      This function converts inserted text to capital letters.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
field_check_allcaps(Widget text_w, XtPointer client_data, XtPointer call_data) {

  int len;
  XmTextVerifyCallbackStruct *cbs = (XmTextVerifyCallbackStruct *) call_data;

  if (cbs->reason == XmCR_ACTIVATE) {
    char *string = XmTextGetString (text_w);
    XtFree (string);
    XmProcessTraversal (text_w, XmTRAVERSE_NEXT_TAB_GROUP);
    return;
  }
  
  if (cbs->text->ptr == NULL)  
    return;
  
  /* convert all input to upper-case if necessary */
  for (len = 0; len < cbs->text->length; len++)
    if (islower (cbs->text->ptr[len]))
      cbs->text->ptr[len] = toupper (cbs->text->ptr[len]);
}



/*
 *----------------------------------------------------------------------
 *
 * field_check_allcaps --
 *
 *      This function limit the user to entering a ZIP code.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
field_check_zip(Widget text_w, XtPointer client_data, XtPointer call_data) {

  int len = XmTextGetLastPosition (text_w);
  XmTextVerifyCallbackStruct *cbs = (XmTextVerifyCallbackStruct *) call_data;
  
  if (cbs->reason == XmCR_ACTIVATE) {
    if (len == 5) {
      char *string = XmTextGetString (text_w);
      XtFree (string);
      XmProcessTraversal (text_w, XmTRAVERSE_NEXT_TAB_GROUP);
    }
    return;
  }
  
  if (cbs->startPos < cbs->currInsert) /* backspace */
    return;
  
  if (len == 5) {
    cbs->doit = False;
    return;
  }
  /* check that the new additions won't put us over 5 */
  if (len + cbs->text->length > 5) {
    cbs->text->ptr[5 - len] = 0;
    cbs->text->length = strlen (cbs->text->ptr);
  }
  for (len = 0; len < cbs->text->length; len++) {
    /* make sure all additions are digits. */
    if (!isdigit (cbs->text->ptr[len])) {
      /* not a digit-- move all chars down one and
       * decrement cbs->text->length.
       */
      int i;
      for (i = len; (i+1) < cbs->text->length; i++)
	cbs->text->ptr[i] = cbs->text->ptr[i+1];
      cbs->text->length--;
      len--;
    }
  }
  if (cbs->text->length == 0)
    cbs->doit = False;
}



/*
 *----------------------------------------------------------------------
 *
 * field_check_allcaps --
 *
 *      This function handle the input of a password.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
field_check_passwd(Widget text_w, XtPointer client_data, XtPointer call_data) {

  char *new;
  int len;
  XmTextVerifyCallbackStruct *cbs = (XmTextVerifyCallbackStruct *) call_data;
  
  if (cbs->reason == XmCR_ACTIVATE) {
    XmProcessTraversal(text_w, XmTRAVERSE_NEXT_TAB_GROUP);
    return;
  }
  
  if (cbs->startPos < cbs->currInsert) {   /* backspace */
    cbs->endPos = strlen (passwd);         /* delete from here to end */
    passwd[cbs->startPos] = 0;             /* backspace--terminate */
    return;
  }
  
  if (cbs->text->length > 1) {
    cbs->doit = False;                     /* don't allow "paste" operations */
    return;                                /* make the user *type* the password! */
  }
  
  new = XtMalloc (cbs->endPos + 2);        /* new char + NULL terminator */
  if (passwd) {
    strcpy (new, passwd);
    XtFree (passwd);
  } else
    new[0] = '\0';
  passwd = new;
  strncat (passwd, cbs->text->ptr, cbs->text->length);
  passwd[cbs->endPos + cbs->text->length] = 0;
  
  for (len = 0; len < cbs->text->length; len++)
    cbs->text->ptr[len] = '*';
}



/*
 *----------------------------------------------------------------------
 *
 * field_check_allcaps --
 *
 *      This function  limit the user to entering a float
 *      (or an interger) number.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
field_check_float(Widget text_w, XtPointer client_data, XtPointer call_data) {

  int point = 0;
  int len = XmTextGetLastPosition (text_w);
  XmTextVerifyCallbackStruct *cbs = (XmTextVerifyCallbackStruct *) call_data;
  
  if( cbs->reason == XmCR_ACTIVATE ) {
    if (len == 5) {
      char *string = XmTextGetString( text_w );
      XtFree( string );
      XmProcessTraversal(text_w, XmTRAVERSE_NEXT_TAB_GROUP);
    }
    return;
  }
  
  if( cbs->startPos < cbs->currInsert ) /* backspace */
    return;
  
  if( len == 5 ) {
    cbs->doit = False;
    return;
  }
  /* check that the new additions won't put us over 5 */
  if( len + cbs->text->length > 5 ) {
    cbs->text->ptr[5 - len] = 0;
    cbs->text->length = strlen( cbs->text->ptr );
  }

  for( len = 0; len < cbs->text->length; len++ ) {

    /* make sure all additions are digits. and/or there's a floatting point */

    if( !isdigit(cbs->text->ptr[len]) ) {
      if( cbs->text->ptr[len] == '.' && point == 0 )
	point = 1;
      else {
	int i;
	for(i = len; (i+1) < cbs->text->length; i++)
	  cbs->text->ptr[i] = cbs->text->ptr[i+1];
	cbs->text->length--;
	len--;
      }
    }
  }
  if( cbs->text->length == 0 )
    cbs->doit = False;
}
