/* 
 * mainWin.cc --
 *
 *      This file contains the fonction that creates the GUI,
 *      and alse some functions to manage the scale widget of
 *      the 'Welcome' window.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include <unistd.h>
#include <X11/Intrinsic.h>

#include <Xm/MainW.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/LabelG.h>
#include <Xm/Scale.h>
#include <Xm/Command.h>
#include <Xm/Frame.h>
#include <Xm/Scale.h>

#include <X11/xpm.h>

#include "globals.h"
#include "menus.h"
#include "dialogs.h"
#include "widgets.h"
#include "actions.h"
#include "callbacks.h"

#include "../pixmaps/icon.xpm"
#include "../pixmaps/intro.xpm"

Widget mainToolBar, mainFormatBar, mainDrawing, mainLabel, mainCommand;
Widget balloon;
Widget print_dialog, params_dialog, infos_dialog;
Widget zoom_om, style_om, fontFamily_om, fontSize_om;
Widget scale;

AppInfo appInfo;

static XtResource Resources[] = {

  {"newName",    "NewName",     XtRString,  sizeof(char *),
     XtOffsetOf(AppInfo, new_name),   XtRString,  (XtPointer)NULL},
  {"visual", "Visual", XtRVisual, sizeof(Visual *),
     XtOffsetOf(AppInfo, visual), XtRImmediate, NULL},
  {"depth", "Depth", XtRInt, sizeof (int),
     XtOffsetOf(AppInfo, depth), XtRImmediate, NULL},
  {"quit_msg",    "QuitMsg",     XtRString,  sizeof(char *),
     XtOffsetOf(AppInfo, quit_msg),   XtRString,  (XtPointer)NULL}
};




/*
 *----------------------------------------------------------------------
 *
 * GUI_DrawPAPYRUS_Version --
 *
 *      This method is invoked to display the version number and the
 *      date of the PAPyRUS application in the Welcome Dialog.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
GUI_DrawPAPYRUS_Version(Widget dialog, Widget image) {

  Display *disp;
  Drawable draw;
  XGCValues gcv;
  XFontStruct *xfs;
  int x;
  GC gc;

  disp = XtDisplay(dialog);
  draw = XtWindow(image);
  
  gcv.function = GXcopy;
  gcv.foreground = BlackPixel(disp, DefaultScreen(disp));
  gc = XCreateGC(disp, draw, GCFunction|GCForeground, &gcv);
  
  xfs = XLoadQueryFont(disp, "fixed");
  x = XTextWidth(xfs, PAPYRUS_VERSION, strlen(PAPYRUS_VERSION));
  XDrawString(disp, draw, gc,
	      340-x, 225, PAPYRUS_VERSION, strlen(PAPYRUS_VERSION));
  
  x = XTextWidth(xfs, PAPYRUS_DATE, strlen(PAPYRUS_DATE));
  XDrawString(disp, draw, gc,
	      340-x, 240, PAPYRUS_DATE, strlen(PAPYRUS_DATE));
  XFreeGC(disp, gc);
  XFreeFont(disp, xfs);
}



/*
 *----------------------------------------------------------------------
 *
 * GUI_CreateWelcome_Dialog --
 *
 *      This method is invoked to create the Welcome dialog at the
 *      start of PAPyRUS.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
GUI_CreateWelcome_Dialog(void) {

  Widget dialog, form, image, label;

  dialog = XtVaCreatePopupShell("welcome",
				overrideShellWidgetClass, toplevel,
				XmNallowShellResize, True,
				XmNx, 334,
				XmNy, 256,
				NULL);

  form = XtVaCreateManagedWidget("rowcol",
				 xmFormWidgetClass,
				 dialog,
				 NULL);


  XpmCreatePixmapFromData(XtDisplay(toplevel),
                          RootWindowOfScreen(XtScreen(toplevel)),
                          intro_xpm,
                          &about_pixmap,
                          NULL, NULL);

  image = XtVaCreateManagedWidget("image",
				  xmLabelGadgetClass,
				  form,
				  XmNtopAttachment, XmATTACH_FORM,
				  XmNleftAttachment, XmATTACH_FORM,
				  XmNrightAttachment, XmATTACH_FORM,
				  XmNlabelType, XmPIXMAP,
				  XmNlabelPixmap, about_pixmap,
				  NULL);

  label = XtVaCreateManagedWidget("IntroMessage",
				  xmLabelGadgetClass,
				  form,
				  XmNtopAttachment, XmATTACH_WIDGET,
				  XmNtopWidget, image,
				  XmNleftAttachment, XmATTACH_FORM,
				  XmNrightAttachment, XmATTACH_FORM,
				  NULL);

  scale = XtVaCreateManagedWidget("scale",
				  xmScaleWidgetClass,
				  form,
				  XmNeditable, False,
				  XmNvalue, 0,
				  XmNorientation, XmHORIZONTAL,
				  XmNtopAttachment, XmATTACH_WIDGET,
				  XmNtopWidget, label,
				  XmNbottomAttachment, XmATTACH_FORM,
				  XmNleftAttachment, XmATTACH_FORM,
				  XmNrightAttachment, XmATTACH_FORM,
				  XmNscaleHeight, 25,
				  XmNsliderMark, XmNONE,
				  XmNslidingMode, XmTHERMOMETER,
  				  NULL);

  GUI_DrawPAPYRUS_Version(dialog, image);

  XtRealizeWidget(dialog);
  XtAddCallback(dialog, XmNpopupCallback, (XtCallbackProc)CenterDialog_CB, NULL);
  XtPopup(dialog, XtGrabNone);
}


/*
 *----------------------------------------------------------------------
 *
 * Scale_Increment --
 *
 *      This function is invoked to add 10 (points) to the current
 *      scale widget.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
Scale_Increment() {
  
  int value;
  extern Widget scale;

  XmScaleGetValue(scale, &value);
  XmScaleSetValue(scale, value+10);
}



/*
 *----------------------------------------------------------------------
 *
 * Intro_Message --
 *
 *      This function is invoked to change the Welcome message label
 *      (on the slider).
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
Intro_Message(char *string) {

  XtVaSetValues(XtNameToWidget(toplevel, "*IntroMessage"),
		XmNlabelString, XmStringCreateSimple(string),
		NULL);
  XmUpdateDisplay(toplevel);
}



/*
 *----------------------------------------------------------------------
 *
 * Fatal_Intro_Message --
 *
 *      This function is invoked to change the Welcome message label
 *      (on the slider) when an fatal error occurs.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
Fatal_Intro_Message(char *string) {

  Intro_Message(string);
  sleep(10);
  exit(1);
}



/*
 *----------------------------------------------------------------------
 *
 * GUI_Create --
 *
 *      This function is invoked to created the PAPyRUS GUI.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
GUI_Create(void) {

  Widget mainWindow, menuBar, mainForm, frame;
  Widget mainRowColumn1, mainRowColumn2;
  Pixmap pixmap;

  XtGetApplicationResources(toplevel, (XtPointer)&appInfo, Resources,
			    XtNumber(Resources), (ArgList) NULL, 0);

  if( appInfo.new_name == NULL )
    Fatal_Intro_Message("Can't find the app-default file");

  XpmCreatePixmapFromData(XtDisplay(toplevel),
			  RootWindowOfScreen(XtScreen(toplevel)),
			  icon_xpm,
			  &pixmap,
			  NULL, NULL);
  XtVaSetValues(toplevel, XmNiconPixmap, pixmap, NULL);

  mainWindow = XtVaCreateManagedWidget("mainWindow",
				       xmMainWindowWidgetClass,
				       toplevel,
				       XmNunitType, XmPIXELS,
				       XmNcommandWindowLocation, XmCOMMAND_BELOW_WORKSPACE,
				       NULL );

  mainForm = XtVaCreateManagedWidget("mainForm",
				     xmFormWidgetClass,
				     mainWindow,
				     XmNspacing, 0,
				     NULL);
  
  mainToolBar = XtVaCreateManagedWidget("mainToolBar",
					xmFormWidgetClass,
					mainForm,
					NULL);

  Scale_Increment();

  frame = XtVaCreateManagedWidget("mainFrame1",
				  xmFrameWidgetClass,
				  mainToolBar,
				  XmNspacing, 0,
				  XmNmarginHeight, 0,
				  NULL);

  mainRowColumn1 = XtVaCreateManagedWidget("mainRowColumn1",
					   xmRowColumnWidgetClass,
					   frame,
					   XmNorientation, XmHORIZONTAL,
					   XmNspacing, 0,
					   XmNmarginHeight, 0,
					   NULL);

  mainFormatBar = XtVaCreateManagedWidget("mainFormatBar",
					  xmFormWidgetClass,
					  mainForm,
					  XmNtopAttachment, XmATTACH_WIDGET,
					  XmNtopWidget, mainToolBar,
					  NULL);

  Scale_Increment();
  
  frame = XtVaCreateManagedWidget("mainFrame2",
				  xmFrameWidgetClass,
				  mainFormatBar,
				  XmNspacing, 0,
				  XmNmarginHeight, 0,
				  NULL);

  mainRowColumn2 = XtVaCreateManagedWidget("mainRowColumn2",
					   xmRowColumnWidgetClass,
					   frame,
					   XmNorientation, XmHORIZONTAL,
					   XmNspacing, 0,
					   XmNmarginWidth, 0,
					   XmNmarginHeight, 0,
					   NULL);

  menuBar = GUI_CreateMenus( mainWindow );

  Scale_Increment();

  GUI_CreateIconBar( mainRowColumn1, 3);
  GUI_CreateIconBar( mainRowColumn1, 2);
  GUI_CreateIconBar( mainRowColumn1, 4);
  GUI_CreateIconBar( mainRowColumn1, 1);
  GUI_CreateIconBar( mainRowColumn1, 3);

  Scale_Increment();

  zoom_om = GUI_CreateOptionMenu(mainRowColumn1, 0, "zoom", NULL);

  GUI_CreateIconBar(mainRowColumn1, 1);  

  style_om      = GUI_CreateOptionMenu(mainRowColumn2, 0,  "style", NULL);
  fontFamily_om = GUI_CreateOptionMenu( mainRowColumn2, 0, "family", NULL);
  fontSize_om   = GUI_CreateOptionMenu( mainRowColumn2, 0, "size", NULL);

  GUI_CreateIconBar( mainRowColumn2, 3);
  GUI_CreateIconBar( mainRowColumn2, 4);
  
  balloon = GUI_CreateBalloon( toplevel );
  
  mainDrawing = GUI_CreateMainDrawing( mainForm, mainFormatBar );

  Scale_Increment();

  mainCommand =  XtVaCreateWidget("mainCommand",
				  xmCommandWidgetClass,
				  mainWindow,
				  XmNhistoryVisibleItemCount, 2,
				  XmNmarginHeight, 0,
				  NULL);

  XtAddCallback(XmCommandGetChild(mainCommand, XmDIALOG_COMMAND_TEXT),
		XmNactivateCallback,(XtCallbackProc)command_CB, (XtPointer)2);
  
  mainLabel   = GUI_CreateMainMessage( mainWindow );

  XtVaSetValues(mainWindow,
		XmNmessageWindow, mainLabel,
		NULL);

  params_dialog = NULL;
  print_dialog = NULL;

  Intro_Message("Creating message dialogs");
  GUI_CreateMessage_Dialogs(toplevel);

  XmMainWindowSetAreas(mainWindow, menuBar, mainCommand, (Widget)NULL, (Widget)NULL, mainForm);

  Scale_Increment();
}
