/* 
 * init.cc --
 *
 *      This file contains fonctions that are called for
 *      initialisation of the dialog entries before they are
 *      mapped.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include <Xm/TextF.h>
#include <Xm/ToggleBG.h>

#include "init.h"
#include "../tcl/mytcl.h"
#include "callbacks.h"



/*
 *----------------------------------------------------------------------
 *
 * GUI_InitPrintDialog --
 *
 *      This function fills the entries of the 'Print' dialog.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
GUI_InitPrintDialog(Widget dialog) {

  char *string;
  Widget om, button;

  om = XtNameToWidget(dialog, "*printDeviceOM_rc");
  string = Tcl_GetVar2(theInterp, "print", "device", TCL_GLOBAL_ONLY);

  if( string[0] == 'f' && strcmp(string, "file") == 0 ) {
    button = XtNameToWidget(dialog, "*printDeviceOM_b1");
    XtCallCallbacks(button, XmNactivateCallback, (XtPointer)1);
  } else {
    button = XtNameToWidget(dialog, "*printDeviceOM_b0");
    XtCallCallbacks(button, XmNactivateCallback, (XtPointer)0);
  }
  XtVaSetValues(om, XmNmenuHistory, button, NULL);

  om = XtNameToWidget(dialog, "*printFormatOM_rc");
  string = Tcl_GetVar2(theInterp, "print", "format", TCL_GLOBAL_ONLY);

  if( string[0] == 'l' && strcmp(string, "letter") == 0 ) {
    button = XtNameToWidget(dialog, "*printFormatOM_b0");
    XtCallCallbacks(button, XmNactivateCallback, (XtPointer)1);
  } else if( string[2] == 'g' && strcmp(string, "legal") == 0 ) {
    button = XtNameToWidget(dialog, "*printFormatOM_b1");
    XtCallCallbacks(button, XmNactivateCallback, (XtPointer)1);
  } else if( string[0] == 'e' && strcmp(string, "executive") == 0 ) {
    button = XtNameToWidget(dialog, "*printFormatOM_b2");
    XtCallCallbacks(button, XmNactivateCallback, (XtPointer)1);
  } else {
    button = XtNameToWidget(dialog, "*printFormatOM_b3");
    XtCallCallbacks(button, XmNactivateCallback, (XtPointer)1);
  }
  XtVaSetValues(om, XmNmenuHistory, button, NULL);

  string = Tcl_GetVar2(theInterp, "print", "orient", TCL_GLOBAL_ONLY);
  if( string[0] == 'l' && strcmp(string, "landscape") == 0 )
    button = XtNameToWidget(dialog, "*paperOrient_b1");
  else
    button = XtNameToWidget(dialog, "*paperOrient_b0");
  XmToggleButtonGadgetSetState(button, True, True);


  XmTextFieldSetString(XtNameToWidget(dialog, "*prn_form.field_text"),
		       Tcl_GetVar2(theInterp, "print", "printer", TCL_GLOBAL_ONLY));
  XmTextFieldSetString(XtNameToWidget(dialog, "*cmd_form.field_text"),
		       Tcl_GetVar2(theInterp, "print", "command", TCL_GLOBAL_ONLY));
  XmTextFieldSetString(XtNameToWidget(dialog, "*file_form.fileName_text"),
		       Tcl_GetVar2(theInterp, "print" ,"file", TCL_GLOBAL_ONLY));
}



/*
 *----------------------------------------------------------------------
 *
 * GUI_InitParamsDialog --
 *
 *      This function fills the entries of the 'Parameters' dialog.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
GUI_InitParamsDialog(Widget dialog) {

  char *string;

  Tcl_MyEval("Get_DocParams");

  string = Tcl_GetVar2(theInterp, "common", "left", TCL_GLOBAL_ONLY);
  XmTextFieldSetString(XtNameToWidget(dialog, "*leftMargin_form.field_text"), string);

  string = Tcl_GetVar2(theInterp, "common", "right", TCL_GLOBAL_ONLY);
  XmTextFieldSetString(XtNameToWidget(dialog, "*rightMargin_form.field_text"), string);

  string = Tcl_GetVar2(theInterp, "common", "top", TCL_GLOBAL_ONLY);
  XmTextFieldSetString(XtNameToWidget(dialog, "*upMargin_form.field_text"), string);

  string = Tcl_GetVar2(theInterp, "common", "bottom", TCL_GLOBAL_ONLY);
  XmTextFieldSetString(XtNameToWidget(dialog, "*downMargin_form.field_text"), string);

  Tcl_MyEval("Get_ParaParams");

  string = Tcl_GetVar2(theInterp, "common", "left", TCL_GLOBAL_ONLY);
  XmTextFieldSetString(XtNameToWidget(dialog, "*leftSpace_form.field_text"), string);

  string = Tcl_GetVar2(theInterp, "common", "right", TCL_GLOBAL_ONLY);
  XmTextFieldSetString(XtNameToWidget(dialog, "*rightSpace_form.field_text"), string);

  string = Tcl_GetVar2(theInterp, "common", "fline", TCL_GLOBAL_ONLY);
  XmTextFieldSetString(XtNameToWidget(dialog, "*flineSpace_form.field_text"), string);
}


void
GUI_InitInfosDialog(Widget dialog) {

  char *string;

  Tcl_MyEval("Get_DocInfos");

  string = Tcl_GetVar2(theInterp, "common", "title", TCL_GLOBAL_ONLY);
  XmTextFieldSetString(XtNameToWidget(dialog, "*title_form.field_text"), string);

  string = Tcl_GetVar2(theInterp, "common", "owner", TCL_GLOBAL_ONLY);
  XmTextFieldSetString(XtNameToWidget(dialog, "*owner_form.field_text"), string);
}
