/* 
 * dialogs.cc --
 *
 *      This file contains fonctions that creates dialog boxes.
 *
 * Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include <stdio.h>
#include <X11/Intrinsic.h>

#include <Xm/DialogS.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>
#include <Xm/MessageB.h>
#include <Xm/LabelG.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <Xm/ToggleBG.h>
#include <Xm/List.h>
#include <Xm/Text.h>
#include <Xm/ScrolledW.h>
#include <Xm/FileSB.h>

#include <X11/xpm.h>

#include "dialogs.h"
#include "widgets.h"
#include "callbacks.h"
#include "init.h"

#include "../pixmaps/question.xpm"
#include "../pixmaps/portrait.xpm"
#include "../pixmaps/landscape.xpm"


Widget zoomCharWidget;
int zoomCharNumber;
Widget error_dialog, question_dialog;
Pixmap paperOrient_xpm[2];
Pixmap about_pixmap;

/*
 *----------------------------------------------------------------------
 *
 * GUI_CreateInfos_Dialog --
 *
 *      This function creates the 'Information' dialog.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

Widget
GUI_CreateInfos_Dialog(Widget parent) {
  
  Widget dialog;

  dialog = XmCreateMessageDialog(parent, "infos", NULL, 0);

  XtUnmanageChild( XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON ) );
  XtUnmanageChild( XmMessageBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON ) );

  XtVaSetValues(dialog,
		XmNmarginWidth, 0,
		XmNmarginHeight, 0,
		XmNsymbolPixmap, about_pixmap,
		NULL);

  XtAddCallback(dialog, XmNokCallback, infos_CB, (XtPointer)True );
  
  GUI_RealizeDialog(dialog);

  return dialog;
}



/*
 *----------------------------------------------------------------------
 *
 * GUI_CreateQuit_Dialog --
 *
 *      This function creates the 'Quit' dialog.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

Widget
GUI_CreateQuit_Dialog(Widget parent) {
  
  Widget dialog;

  dialog = XmCreateMessageDialog(parent, "quit", NULL, 0);

  XtUnmanageChild( XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON ) );

  XtVaSetValues(dialog,
		XmNmessageAlignment, XmALIGNMENT_CENTER,
		XmNdefaultButtonType, XmDIALOG_CANCEL_BUTTON,
		NULL);

  XtAddCallback(dialog, XmNokCallback, quit_CB, (XtPointer)True );
  XtAddCallback(dialog, XmNcancelCallback, quit_CB, (XtPointer)False );

  GUI_RealizeDialog(dialog);

  return dialog;
}



/*
 *----------------------------------------------------------------------
 *
 * GUI_CreateSpecialChars_Dialog --
 *
 *      This function creates the 'Special Characters' dialog. This
 *      dialog is used for inserting non latin characters in the
 *      document.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

Widget
GUI_CreateSpecialChars_Dialog(Widget parent) {

  Widget dialog, mainTBox, widget;
  XmFontList mainFL, zoomFL;
  int i, n;
  char chaine[2];
  char font[64];
  XFontStruct *police1, *police2;


  sprintf(font, "-adobe-%s-medium-r-normal--28-*-*-*-*-*-*-*", "symbol");
  police1 = XLoadQueryFont(XtDisplay(parent), (const char *)font);
  
  zoomFL = XmFontListCreate(police1, XmFONTLIST_DEFAULT_TAG);
  
  zoomCharNumber = -1;
  zoomCharWidget = XtVaCreatePopupShell("zoom",
					overrideShellWidgetClass, parent,
					XmNallowShellResize, True,
					NULL);
  
  XtVaCreateManagedWidget("zoomLabel",
			  xmLabelWidgetClass,
			  zoomCharWidget,
			  XmNmarginWidth, 1,
			  XmNmarginHeight, 1,
			  XmNrecomputeSize, False,
			  XmNfontList, zoomFL,
			  NULL);

  dialog = XmCreateMessageDialog(parent, "sChars", NULL, 0);

  mainTBox = XtVaCreateManagedWidget("toggleBox",
				     xmRowColumnWidgetClass,
				     dialog,
				     XmNnumColumns, 10,
				     XmNpacking, XmPACK_COLUMN,
				     XmNorientation, XmHORIZONTAL,
				     XmNtopAttachment,    XmATTACH_FORM,
				     XmNbottomAttachment, XmATTACH_FORM,
				     XmNrightAttachment,  XmATTACH_FORM,
				     XmNleftAttachment,   XmATTACH_FORM,
				     NULL);

  sprintf(font, "-adobe-%s-medium-r-normal--10-*-*-*-*-*-*-*", "symbol");

  XtRemoveAllCallbacks(XmMessageBoxGetChild(dialog, XmDIALOG_OK_BUTTON), XmNactivateCallback);
  XtAddCallback(XmMessageBoxGetChild(dialog, XmDIALOG_OK_BUTTON),
		XmNactivateCallback, specialChars_insert_CB,
		(XtPointer)NULL);
  XtAddCallback(dialog, XmNcancelCallback, specialChars_cancel_CB, (XtPointer)NULL);

  /*
   * Create the button box
   */

  police2 = XLoadQueryFont(XtDisplay(parent), (const char *)font);
  mainFL = XmFontListCreate(police2, XmFONTLIST_DEFAULT_TAG);
  n = ((police2->min_byte1 << 8) | police2->min_char_or_byte2);

  for(i=police2->min_char_or_byte2; i<=police2->max_char_or_byte2; i++) {

    char *s = XKeysymToString ((KeySym) n);
    
    if( s ) {
      sprintf(chaine, "%c", n);
      widget = XtVaCreateManagedWidget(chaine,
				       xmPushButtonGadgetClass,
				       mainTBox,
				       XmNlabelString, XmStringCreateSimple(chaine),
				       XmNfontList, mainFL,
				       XmNeditable, False,
				       NULL);
      XtAddCallback(widget, XmNarmCallback, specialChars_select_CB, (XtPointer)n);
    }
    n++;
  }

  GUI_RealizeDialog(dialog);
  return dialog;
}



/*
 *----------------------------------------------------------------------
 *
 * GUI_CreateParams_Dialog --
 *
 *      This function creates the 'Parameters' dialog. This
 *      dialog contains one notebook, which has three pages~: one
 *      for the Document, one for the Page, and one for the Characters.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

Widget
GUI_CreateParams_Dialog(Widget parent) {
  
  Widget dialog;
  Widget notebook;
  Widget form;

  dialog = XmCreateMessageDialog(parent, "params", NULL, 0);

  form = XtVaCreateManagedWidget("form",
				 xmFormWidgetClass,
				 dialog,
				 XmNbottomAttachment, XmATTACH_FORM,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 XmNtopAttachment, XmATTACH_FORM,			  
				 NULL);

  XtAddCallback(dialog, XmNokCallback, params_CB, (XtPointer)True );
  XtAddCallback(dialog, XmNcancelCallback, params_CB, (XtPointer)False );
  
  notebook = GUI_CreateNoteBook(form);

  Create_DocumentParamsPage(notebook);
  Create_CharParamsPage(notebook);
  Create_ParagraphParamsPage(notebook);

  GUI_InitParamsDialog(dialog);

  GUI_RealizeDialog(dialog);

  return dialog;
}



/*
 *----------------------------------------------------------------------
 *
 * GUI_CreatePrint_Dialog --
 *
 *      This function creates the 'Print' dialog. This dialog
 *      is used for printing the document.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

Widget
GUI_CreatePrint_Dialog(Widget parent) {

  Widget dialog, toggle, label, orientLabel;
  Widget mainForm, rowcol, frame, form, optionMenu;
  Widget outputlabel;


  dialog = XmCreateMessageDialog(parent, "print", NULL, 0);

  mainForm = XtVaCreateManagedWidget("form",
				     xmFormWidgetClass,
				     dialog,
				     XmNbottomAttachment, XmATTACH_FORM,
				     XmNleftAttachment, XmATTACH_FORM,
				     XmNrightAttachment, XmATTACH_FORM,
				     XmNtopAttachment, XmATTACH_FORM,
				     XmNhorizontalSpacing, 5,
				     NULL);
  
  frame = XtVaCreateManagedWidget("paperFrame",
				  xmFrameWidgetClass,
				  mainForm,
				  XmNbottomAttachment, XmATTACH_FORM,
				  XmNleftAttachment, XmATTACH_FORM,
				  XmNtopAttachment, XmATTACH_FORM,
				  NULL);
  
  XtVaCreateManagedWidget("paperLabel",
			  xmLabelGadgetClass,
			  frame,
			  XmNchildType, XmFRAME_TITLE_CHILD,
			  XmNchildVerticalAlignment, XmALIGNMENT_CENTER,
			  NULL);
  
  form = XtVaCreateManagedWidget("paperForm",
				 xmFormWidgetClass,
				 frame,
				 XmNhorizontalSpacing, 20,
				 NULL);
  
  label = XtVaCreateManagedWidget("paperSizeLabel",
				  xmLabelGadgetClass,
				  form,
				  XmNtopAttachment, XmATTACH_FORM,
				  NULL);
  
  optionMenu = GUI_CreateOptionMenu(form, 4, "printFormat", printFormat_CB);
  
  XtVaSetValues(optionMenu,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget, label,
		NULL);
  
  orientLabel = XtVaCreateManagedWidget("paperOrientLabel",
					xmLabelGadgetClass,
					form,
					XmNtopAttachment, XmATTACH_WIDGET,
					XmNtopWidget, optionMenu,
					NULL);

  XpmCreatePixmapFromData(XtDisplay(parent),
			  RootWindowOfScreen(XtScreen(parent)),
			  portrait_xpm,
			  &paperOrient_xpm[0],
			  NULL, NULL);

  XpmCreatePixmapFromData(XtDisplay(parent),
			  RootWindowOfScreen(XtScreen(parent)),
			  landscape_xpm,
			  &paperOrient_xpm[1],
			  NULL, NULL);
  
  label = XtVaCreateManagedWidget("paperBitmap",
				  xmLabelGadgetClass,
				  form,
				  XmNlabelType, XmPIXMAP,
				  XmNlabelPixmap, paperOrient_xpm[0],
				  XmNtopAttachment, XmATTACH_WIDGET,
				  XmNtopWidget, orientLabel,
				  XmNleftAttachment, XmATTACH_FORM,
				  XmNtopOffset, 15,
				  XmNleftOffset, 20,
				  NULL);
  
  rowcol = XtVaCreateManagedWidget("paperRC",
				   xmRowColumnWidgetClass,
				   form,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNtopWidget, orientLabel,
				   XmNrightAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNradioBehavior, True,
				   NULL);
  
  toggle = XtVaCreateManagedWidget("paperOrient_b0",
				   xmToggleButtonGadgetClass,
				   rowcol,
				   XmNset, True,
				   NULL );
  
  XtAddCallback(toggle, XmNarmCallback, printOrient_CB, (XtPointer)0);
  
  toggle = XtVaCreateManagedWidget("paperOrient_b1",
				   xmToggleButtonGadgetClass,
				   rowcol,
				   NULL );

  XtAddCallback(toggle, XmNarmCallback, printOrient_CB, (XtPointer)1);
  
  frame = XtVaCreateManagedWidget("deviceFrame",
				  xmFrameWidgetClass,
				  mainForm,
				  XmNbottomAttachment, XmATTACH_FORM,
				  XmNrightAttachment, XmATTACH_FORM,
				  XmNtopAttachment, XmATTACH_FORM,
				  XmNhorizontalSpacing, 5,
				  XmNleftAttachment, XmATTACH_WIDGET,
				  XmNleftWidget, frame,
				  NULL);
  
  XtVaCreateManagedWidget("deviceLabel",
			  xmLabelGadgetClass,
			  frame,
			  XmNchildType, XmFRAME_TITLE_CHILD,
			  XmNchildVerticalAlignment, XmALIGNMENT_CENTER,
			  NULL);
  
  form = XtVaCreateManagedWidget("deviceForm",
				 xmFormWidgetClass,
				 frame,
				 XmNhorizontalSpacing, 10,
				 XmNverticalSpacing, 10,
				 NULL);
  
  outputlabel = XtVaCreateManagedWidget("outputLabel",
					xmLabelGadgetClass,
					form,
					XmNtopAttachment, XmATTACH_FORM,
					NULL);
  
  optionMenu = GUI_CreateOptionMenu(form, 2, "printDevice", printDevice_CB);
  
  XtVaSetValues(optionMenu,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget, outputlabel,
		NULL);
  
  rowcol = XtVaCreateManagedWidget("deviceRC",
				   xmRowColumnWidgetClass,
				   form,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNtopWidget, optionMenu,
				   XmNrightAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  
  label = GUI_CreateFieldItem(rowcol, NORMAL_FIELD, 15, "prn", 7);
  
  XtVaSetValues(XtNameToWidget(label, "*field_text"),
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
  label = GUI_CreateFieldItem(rowcol, NORMAL_FIELD, 15, "cmd", 8);
  
  XtVaSetValues(XtNameToWidget(label, "*field_text"),
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
  
  label = GUI_CreateFileNameField(rowcol, 8, "file", filePrintSearch_CB, 9);
  
  XtAddCallback(dialog, XmNokCallback, print_CB, (XtPointer)True);
  XtAddCallback(dialog, XmNcancelCallback, print_CB, (XtPointer)False);
  
  GUI_InitPrintDialog(dialog);
  GUI_RealizeDialog(dialog);
  
  return dialog;
}



/*
 *----------------------------------------------------------------------
 *
 * GUI_CreateMessage_Dialogs --
 *
 *      This function creates the 'Message' dialogs. One for the
 *      errors history, and the other for the common messages.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */
     
void
GUI_CreateMessage_Dialogs(Widget parent) { 

  Widget dialog;
  Arg args[20];
  int n;
  Pixmap pixmap;

  /*
   * We don't use ErrorDialogs neither 'QuestionDialogs' because
   * our version of Motif has a bug, and fails if invoked !!!
   */

  question_dialog = XmCreateMessageDialog(parent, "question", NULL, 0);
  XtUnmanageChild( XmMessageBoxGetChild(question_dialog, XmDIALOG_HELP_BUTTON ) );

  XpmCreatePixmapFromData(XtDisplay(parent),
			  RootWindowOfScreen(XtScreen(parent)),
			  question_xpm,
			  &pixmap,
			  NULL, NULL);

  XtVaSetValues(question_dialog,
		XmNmessageAlignment, XmALIGNMENT_CENTER,
		XmNsymbolPixmap, pixmap,
		NULL);
  GUI_RealizeDialog(question_dialog);


  dialog = XmCreateMessageDialog(parent, "error", NULL, 0);

  XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_MESSAGE_LABEL));

  n = 0;
  XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
  XtSetArg(args[n], XmNrows, 10); n++;
  XtSetArg(args[n], XmNcolumns, 40); n++;
  XtSetArg(args[n], XmNhighlightThickness, 0); n++;
  XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
  XtSetArg(args[n], XmNeditable, False); n++;
  XtSetArg(args[n], XmNverifyBell, False); n++;

  error_dialog = XmCreateScrolledText(dialog, "scrolledText", args, n);
  XtManageChild(error_dialog);

  XtAddCallback(dialog, XmNcancelCallback, error_CB, (XtPointer)1);
  XtAddCallback(dialog, XmNokCallback, error_CB, (XtPointer)0);

  GUI_RealizeDialog(dialog);
}



/*
 *----------------------------------------------------------------------
 *
 * GUI_CreateIspell_Dialog --
 *
 *      This function creates the 'Ispell' dialog. This dialog
 *      allow the user to call an execute Ispell on the document.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

Widget
GUI_CreateIspell_Dialog(Widget parent) { 

  Widget dialog, form, formb, item, button, list, form_base;


  dialog = XmCreateMessageDialog(parent, "ispell", NULL, 0);

  XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_MESSAGE_LABEL));
  XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_OK_BUTTON));

  form_base = XtVaCreateManagedWidget("form_base",
				      xmFormWidgetClass,
				      dialog,
				      NULL);

  form = XtVaCreateManagedWidget("form",
				 xmFormWidgetClass,
				 form_base,
				 XmNbottomAttachment, XmATTACH_FORM,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNtopAttachment, XmATTACH_FORM,
				 NULL);
  
  formb = XtVaCreateManagedWidget("formb",
				  xmFormWidgetClass,
				  form_base,
				  XmNbottomAttachment, XmATTACH_FORM,
				  XmNleftAttachment, XmATTACH_WIDGET,
				  XmNleftWidget, form,
				  XmNrightAttachment, XmATTACH_FORM,
				  XmNtopAttachment, XmATTACH_FORM,
				  NULL);
  
  item = GUI_CreateFieldItem(form, NORMAL_FIELD, 10, "ispell", 10);

  list = XtVaCreateManagedWidget("list",
				 xmListWidgetClass,
				 form,
				 XmNtopAttachment, XmATTACH_WIDGET,
				 XmNtopWidget, item,
				 NULL);

  XtAddCallback(list, XmNbrowseSelectionCallback, ispellList_CB,
		XtNameToWidget(item, "*field_text"));

  button = XtVaCreateManagedWidget("button1",
				   xmPushButtonGadgetClass,
				   formb,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  XtAddCallback(button, XmNactivateCallback, ispell_CB, (XtPointer)0);

  button = XtVaCreateManagedWidget("button2",
				   xmPushButtonGadgetClass,
				   formb,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_WIDGET,
				   XmNbottomWidget, button,
				   NULL);
  XtAddCallback(button, XmNactivateCallback, ispell_CB, (XtPointer)1);

  button = XtVaCreateManagedWidget("button3",
				   xmPushButtonGadgetClass,
				   formb,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_WIDGET,
				   XmNbottomWidget, button,
				   NULL);
  XtAddCallback(button, XmNactivateCallback, ispell_CB, (XtPointer)2);

  XtAddCallback(dialog, XmNcancelCallback, ispellClose_CB, dialog);
  GUI_RealizeDialog(dialog);

  return dialog;
}



/*
 *----------------------------------------------------------------------
 *
 * GUI_CreateDocumentInfo_Dialog --
 *
 *      This function creates the 'Document information' dialog.
 *      This dialog gives some information about the document.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

Widget
GUI_CreateDocumentInfo_Dialog(Widget parent) { 


  Widget dialog, rowcol;

  dialog = XmCreateMessageDialog(parent, "docInfo", NULL, 0);

  XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_MESSAGE_LABEL));
  XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_OK_BUTTON));

  XtAddCallback(dialog, XmNokCallback, documentInfo_CB, (XtPointer)True);
  XtAddCallback(dialog, XmNcancelCallback, documentInfo_CB, (XtPointer)False);
  rowcol = XtVaCreateManagedWidget("documentRC",
				   xmRowColumnWidgetClass,
				   dialog,
				   NULL);

  GUI_CreateFieldItem(rowcol, NORMAL_FIELD, 20, "title", 11);
  GUI_CreateFieldItem(rowcol, NORMAL_FIELD, 20, "owner", 12);

  GUI_InitInfosDialog(dialog);
  GUI_RealizeDialog(dialog);

  return dialog;
}



/*
 *----------------------------------------------------------------------
 *
 * GUI_CreateSelection_Dialog --
 *
 *      This function creates a FileSelection_Dialog.
 *
 * Results:
 *      Returns the FileSelectionBox created.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

Widget
GUI_CreateFileSelection_Dialog(char *name, XtCallbackProc cb) {

  char path[32];
  Widget fileSB;
  extern Widget toplevel;

  sprintf(path, "*%s", name);

  if( XtNameToWidget(toplevel, path) != NULL )
    return NULL;
  
  fileSB = XmCreateFileSelectionDialog(toplevel, name, NULL, 0);
  
  XtAddCallback(fileSB, XmNokCallback, cb, (XtPointer)True);
  XtAddCallback(fileSB, XmNcancelCallback, cb, (XtPointer)False);
  
  XtUnmanageChild( XmFileSelectionBoxGetChild( fileSB, XmDIALOG_HELP_BUTTON ) );

  return fileSB;
}
