# 
# keys-bindings.tcl  --
# 
#       This file contains the Tcl commands for default shortcuts.
# 
#  Copyright (C) 1996-1997  Carlos Nunes - loscar@mime.univ-paris8.fr
# 
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 



#
# Function : Load_Emacs_Bindings
# 
# Set several shorcuts definitions from emacs bindings
#

proc Load_Emacs_Bindings {} {

    SetKey {C-b}  { MoveCursorLeft  }           "Move cursor left"
    SetKey {C-f}  { MoveCursorRight }           "Move cursor right"
    SetKey {C-p}  { MoveCursorUp    }           "Move cursor up"
    SetKey {C-n}  { MoveCursorDown  }           "Move cursor down"

    SetKey {M-f}  { MoveCursorNextWord     }   "Move cursor to next word"
    SetKey {M-b}  { MoveCursorPreviousWord }   "Move cursor to previous word"

    SetKey {C-a}  { MoveCursorBeginLine }      "Move cursor to the beginning of line"
    SetKey {C-e}  { MoveCursorEndLine   }      "Move cursor to the end of line"

    SetKey {C-d}  { DeleteCharacterAfter }     "Delete the character after the cursor"

}


#
# Function : Load_Emacs_Bindings
# 
# Set several shorcuts definitions from Word bindings
#

proc Load_Word_Bindings {} {

    SetKey "C-i"    { Toggle_Italic_Attr          }  "Slant italique"
    SetKey "C-g"    { Toggle_Bold_Attr            }  "Weight gras"
    SetKey "C-m"    { WordConfigure -style normal }  "Weight medium"
}