#
# example2.tcl  -- papyrus document example
#
# This file is part of PAPyRUS
#
# Author: Carlos Nunes
# Date:  17/4/96
#


#
# Define a new style
#

set style NewStyle

set font  { Times   normal 25 }
AddStyle -name $style  -font $font  -align "center" \
	-margins {0 0 0 0} -next $style


#
# Draw the title
#

ParaConfigure -style "Titre1"
  InsertString "ISO 8859-1 Character Set :"
  NewParagraph

ParaConfigure -style $style
  NewParagraph


#
# Display the iso 8859-1 character set
#

set k 0

for {set j 0} {$j<14} {incr j} {
    for {set i 0} {$i<16} {incr i} {
	set num [expr $j*16+$i]
	if { ($num > "32" && $num < "127") || ($num > "160" && $num < "255") } {
	    InsertString [format "%c" $num]
	    
	    incr k
	    if { $k == "20" } {
		NewParagraph
		set k 0
	    }
	}
    }
}
