/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE : mx_wplay_test.C
 *
 * AUTHOR : David Miller
 *
 * This file 
 *
 * DESCRIPTION: 
 * Module mx_wplay_test.C 
 * 
 * 
 *
 *
 */

#include "mx_wp_lay.h"

main() 
{
  int err = MX_ERROR_OK ;
  mx_sheet_size sheets[20] ;
  mx_point    sz(1,1) ;
  mx_point    inc(1,1) ;
  
  mx_wp_layout wplayout(err) ;
 
  for(int i=0;i<20;i++) 
  {
    sheets[i].setSize(sz) ;
    sz += inc ;
  }

  // add the sheets
  wplayout.addSheets(err,0,20,sheets) ;

  inc = wplayout.getTotalSize(err) ;
  
  // remove some sheets
  wplayout.removeSheets(err,1,3) ;

  inc = wplayout.getTotalSize(err) ;

  // put the sheets back 
  wplayout.addSheets(err,1,3,sheets+1) ;

  inc = wplayout.getTotalSize(err) ;

  // change some sheets 

  wplayout.changeSheets(err,15,3,sheets+2) ;

  inc = wplayout.getTotalSize(err) ;

  wplayout.changeSheets(err,15,3,sheets+15) ;

  inc = wplayout.getTotalSize(err) ;

  mx_point testPoint(0.5,10.5) ;
  mx_doc_coord_t testDocCoord ;
  
  wplayout.coordToDocCoord(err,testPoint,testDocCoord,MX_COORD_C);
  wplayout.coordToDocCoord(err,testPoint,testDocCoord,MX_COORD_C);
  wplayout.docCoordToCoord(err,testDocCoord,testPoint);
  
  return ;
  
}







