/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/************************************************************************/
/*                                                                      */ 
/*                                                                      */ 
/* This is the test program for all the frame/view stuff                */
/*                                                                      */ 
/* It creates a frame target which responds to various input events     */
/* In normal maxwell application editors would be subclasses from       */
/* frame targets                                                        */
/*                                                                      */ 
/************************************************************************/

#include "mx_xframe.h" 
#include "mx_sc_device.h" 
#include "mx_wp_lay.h"


// global variables - normally these would be kept on the editor

static mx_scrollable_frame *pxs ;
static int  nsheets = 20 ;

XtAppContext *global_app_context ;

char *global_maxhome;

// the definition of the test frame target 

class my_frame_target:public mx_frame_target
{
  public:
    my_frame_target(int &err, mx_sheet_layout *layout) ;
    my_frame_target(int &err) ;

    // the things this frame target is going to respond to 

    void draw(int &err,mx_draw_event &event) ;
    void buttonPress(int &err,mx_button_event &event) ;
    void buttonDoublePress(int &err,mx_button_event &event) ;
    void buttonTriplePress(int &err,mx_button_event &event) ;
    void buttonMotion(int &err,mx_button_event &event) ;
    void buttonMotionStart(int &err,mx_button_event &event) ;
    void buttonMotionEnd(int &err,mx_button_event &event) ;
    void scrollDrag(int &err,mx_scroll_event &event);
} ;

// the constructor - nothing to do 

my_frame_target::my_frame_target(int &err, mx_sheet_layout *layout)
:mx_frame_target(layout) 
{
}

my_frame_target::my_frame_target(int &err)
:mx_frame_target() 
{
}


void my_frame_target::buttonMotionStart(int &err,mx_button_event &event)
{
    mx_doc_coord_t cd = event.getCoord() ;
    
    printf("BUTTON MOTION start valid %d button %d sheet %d position %f %f\n",
           event.getInRange(),
           event.getButtonNumber(),
           cd.sheet_number,
           cd.p.x,
           cd.p.y) ;    
}

void my_frame_target::buttonMotionEnd(int &err,mx_button_event &event)
{
    mx_doc_coord_t cd = event.getCoord() ;
    
    printf("BUTTON MOTION end valid %d button %d sheet %d position %f %f\n",
           event.getInRange(),
           event.getButtonNumber(),
           cd.sheet_number,
           cd.p.x,
           cd.p.y) ;    
}

void my_frame_target::buttonDoublePress(int &err,mx_button_event &event)
{
    mx_doc_coord_t cd = event.getCoord() ;

    printf("BUTTON DOUBLE PRESS valid %d button %d sheet %d position %f %f\n",
           event.getInRange(),
           event.getButtonNumber(),
           cd.sheet_number,
           cd.p.x,
           cd.p.y) ;
}

void my_frame_target::buttonTriplePress(int &err,mx_button_event &event)
{
    mx_doc_coord_t cd = event.getCoord() ;

    printf("BUTTON TRIPLE PRESS valid %d button %d sheet %d position %f %f\n",
           event.getInRange(),
           event.getButtonNumber(),
           cd.sheet_number,
           cd.p.x,
           cd.p.y) ;
}

    


// a button press - button one   - force scroll
//                  button two   - change document size
//                  button three - zoom 

void my_frame_target::buttonPress(int &err,mx_button_event &event)
{
    mx_doc_coord_t cd = event.getCoord() ;
    static int offset = 0;
    static double zoom = 1 ;
    
    printf("BUTTON PRESS valid %d button %d sheet %d position %f %f\n",
           event.getInRange(),
           event.getButtonNumber(),
           cd.sheet_number,
           cd.p.x,
           cd.p.y) ;

    if(event.getButtonNumber() == 1) 
    {
        // scroll 

        offset++;

        cd.sheet_number = 1 ;
        cd.p.x = 0 ;
        cd.p.y = offset ;
    
        pxs->setTopLeftFrame(err,cd) ;

    }
    else if(event.getButtonNumber() == 2) 
    {
        // change document

        mx_sheet_size sheet ;
        mx_point      sz(nsheets,nsheets) ;

        sheet.setSize(sz) ;
        
        getSheetLayout().addSheets(err,nsheets,1,&sheet) ;
        
        pxs->resetSheetLayout(err);

        nsheets++;
    }        
    else
    {
        // zoom 
        zoom++ ;
        pxs->setZoom(err,zoom) ;
        
    }
    

}

//
// a button motion - just print out details - see if the 
//                   button is in the document
//                  

void my_frame_target::buttonMotion(int &err,mx_button_event &event)
{
    mx_doc_coord_t cd = event.getCoord() ;
    
    printf("BUTTON MOTION valid %d button %d sheet %d position %f %f\n",
           event.getInRange(),
           event.getButtonNumber(),
           cd.sheet_number,
           cd.p.x,
           cd.p.y) ;
}

//
// draw - just fill the sheet
//                  

void my_frame_target::draw(int &err,mx_draw_event &event)
{
    mx_screen_device *device ;
    
    err = MX_ERROR_OK ;
    
    device = (mx_screen_device *) event.getDevice() ;

    // just fill in the page
    device->fillRect(err,event.getTL(),event.getBR()) ;
    
}

//
// scroll draw callback - note the sheet number 
//                  

void my_frame_target::scrollDrag(int &err,mx_scroll_event &event)
{
    err = MX_ERROR_OK ;
    
    mx_doc_coord_t tl = event.getOldTopLeft() ;
    
    printf("SCROLLDRAG:my scroll value %d %f %f\n",tl.sheet_number,tl.p.x,tl.p.y) ;
    
    
    return ;
}



main(int argc,char **argv)
{
    XtAppContext app_context ;
    mx_sheet_size sheets[20] ;
    mx_point    sz(1,1) ;
    mx_point    inc(1,1) ;
    Widget      topLevel ;
    mx_point topLeft1(0,0) ;
    mx_point size(50,50) ;
    mx_point increment(1,1) ;
    mx_doc_coord_t topLeft ;

    global_maxhome = mx_string_copy("/usr/local/maxwell");
    global_app_context = &app_context ;

    int err = MX_ERROR_OK ;
    
    // create a start sheet layout for a word processor

    topLeft.sheet_number = 0 ;
    topLeft.p = topLeft1 ;
    mx_wp_layout wplayout ;
    
    // get coordinates to snap to corners of the document 
    // (needed for per page draw to map corners succesfully) 

    wplayout.setSnapTolerance(0.00001);
    
    for(int i=0;i<20;i++) 
    {
        sheets[i].setSize(sz) ;
        sz += inc ;
    }
    
    // add the sheets
    wplayout.addSheets(err,0,20,sheets) ;
    
    // create a frame target
    //my_frame_target ftarget(err,wplayout) ;
    my_frame_target ftarget(err) ;

    // dont let duplicate button motions reach the
    // target 
    ftarget.setFilterMotion(TRUE);
    
    topLevel = XtVaAppInitialize(&app_context,
                                 "Xtres",
                                 NULL,0,
                                 &argc,argv,NULL,
                                 NULL) ;
    
    // create the scrollable frame for the target 
    mx_scrollable_frame xs(err,
                           topLeft,
                           size,
                           50,
                           ftarget,
                           topLevel,
                           TRUE,
                           increment,
                           FALSE) ;

    // save pointer 
    pxs = &xs ;
    
    // let this frame target be interested in scroll drags
    ftarget.addProcessMask(MX_EVENT_SCROLLDRAG) ;
    
    // dont limit scrolling to the frame target - allow
    // extended scrolling
    xs.setApplyScrollLimitToTarget(FALSE) ;
    
    // get scrolling to follow the mouse
    xs.setMouseScrolling(TRUE) ;
    
    // get drawing events per sheet 
    xs.setDrawPerSheet(TRUE) ;
    
    // go !
    XtRealizeWidget(topLevel) ;
    XtAppMainLoop(app_context) ;
}    
