/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE/CLASS : mx_lv_d
 *
 * AUTHOR : Andrew Haisley
 *
 * This file 
 *
 * DESCRIPTION:
 *
 *  A license violation warning dialog
 *
 *
 *
 *
 */

#include <stdio.h>
#include <dirent.h>
#include <errno.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>

#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleBG.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/Separator.h>
#include <Xm/Protocols.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <mx.h>
#include <mx_std.h>
#include <mx_ui_object.h>
#include "mx_dialog.h"
#include <mx_file_type.h>

#include "mx_lv_d.h"

static void button_cb(
            Widget    widget, 
            XtPointer client_data, 
            XtPointer call_data)
{
    mx_lv_d *d = (mx_lv_d *)client_data;

    if (widget == d->ok_button)
    {
        d->modal_result = yes_e;
    }
}

mx_lv_d::mx_lv_d(Widget parent) : mx_dialog("lv", parent, TRUE, FALSE)
{
    Widget label;
    Widget label1, label2, label3;
    Widget label4, label5, label6;
    Widget label7;

    XmString str;
    char s[20];

    XtVaSetValues(action_area, XmNfractionBase, 3, NULL);

    label = XtVaCreateManagedWidget(
                "label",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,    XmATTACH_FORM,
                XmNleftAttachment,   XmATTACH_FORM,
                XmNrightAttachment,   XmATTACH_FORM,
                NULL);

    label1 = XtVaCreateManagedWidget(
                "label1",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,  XmATTACH_WIDGET,
                XmNtopWidget,      label,
                XmNleftAttachment, XmATTACH_FORM,
                NULL);

    label2 = XtVaCreateManagedWidget(
                "label2",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,  XmATTACH_WIDGET,
                XmNtopWidget,      label1,
                XmNleftAttachment, XmATTACH_FORM,
                NULL);

    label3 = XtVaCreateManagedWidget(
                "label3",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,  XmATTACH_WIDGET,
                XmNtopWidget,      label2,
                XmNleftAttachment, XmATTACH_FORM,
                NULL);

    label4 = XtVaCreateManagedWidget(
                "label4",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,  XmATTACH_WIDGET,
                XmNtopWidget,      label3,
                XmNleftAttachment, XmATTACH_FORM,
                NULL);

    label5 = XtVaCreateManagedWidget(
                "label5",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,  XmATTACH_WIDGET,
                XmNtopWidget,      label,
                XmNleftAttachment, XmATTACH_WIDGET,
                XmNleftWidget,     label3,
                NULL);

    label6 = XtVaCreateManagedWidget(
                "label6",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,  XmATTACH_WIDGET,
                XmNtopWidget,      label5,
                XmNleftAttachment, XmATTACH_WIDGET,
                XmNleftWidget,     label3,
                NULL);

    label7 = XtVaCreateManagedWidget(
                "label7",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,  XmATTACH_WIDGET,
                XmNtopWidget,      label6,
                XmNleftAttachment, XmATTACH_WIDGET,
                XmNleftWidget,     label3,
                NULL);

    num_active_label = XtVaCreateManagedWidget(
                "numActive",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,  XmATTACH_WIDGET,
                XmNtopWidget,      label7,
                XmNleftAttachment, XmATTACH_WIDGET,
                XmNleftWidget,     label3,
                NULL);

    info_text = XtVaCreateManagedWidget("infoText",
                    xmTextWidgetClass, control_area,
                    XmNleftAttachment, XmATTACH_FORM,
                    XmNrightAttachment, XmATTACH_FORM,
                    XmNtopAttachment, XmATTACH_WIDGET,
                    XmNtopWidget, label4,
                    XmNbottomAttachment, XmATTACH_FORM,
                    XmNeditMode, XmMULTI_LINE_EDIT,
                    NULL);

    str = XmStringCreate("none", XmFONTLIST_DEFAULT_TAG);
    XtVaSetValues(label5, XmNlabelString, str, NULL);
    XmStringFree(str);

    str = XmStringCreate("bob", XmFONTLIST_DEFAULT_TAG);
    XtVaSetValues(label6, XmNlabelString, str, NULL);
    XmStringFree(str);

    sprintf(s, "infinite");

    str = XmStringCreate(s, XmFONTLIST_DEFAULT_TAG);
    XtVaSetValues(label7, XmNlabelString, str, NULL);
    XmStringFree(str);

    // now, the action buttons
    ok_button = XtVaCreateManagedWidget(
                "ok",
                xmPushButtonGadgetClass, action_area,
                XmNshowAsDefault, True,
                XmNdefaultButtonShadowThickness, 1,
                XmNleftAttachment,   XmATTACH_POSITION,
                XmNleftPosition,     1,
                XmNrightAttachment,   XmATTACH_POSITION,
                XmNrightPosition,     2,
                NULL);

    XtAddCallback(
            ok_button, 
            XmNactivateCallback, 
            button_cb, 
            (XtPointer)this);

    XtManageChild(action_area);
    XtManageChild(control_area);
    XtManageChild(pane);
}

void mx_lv_d::activate(char *info_file_name, int num_active)
{
    char *text;
    FILE *f;
    int i;
    char s[20];
    XmString str;

    f = fopen(info_file_name, "r");
    if (f == NULL)
    {
        return;
    }

    fseek(f, 0, SEEK_END);
    i = ftell(f);

    text = new char[i + 1];
    if (text == NULL)
    {
        return;
    }

    fseek(f, 0, SEEK_SET);
    fread(text, i, 1, f);
    text[i] = 0;

    XmTextSetString(info_text, text);
    delete [] text;

    sprintf(s, "%d", num_active);
    str = XmStringCreate(s, XmFONTLIST_DEFAULT_TAG);
    XtVaSetValues(num_active_label, XmNlabelString, str, NULL);
    XmStringFree(str);

    mx_dialog::activate();
}
