/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE/CLASS : mx_locked_d
 *
 * AUTHOR : Andrew Haisley
 *
 * This file 
 *
 * DESCRIPTION:
 *
 *  A dialog to tell you a file is locked
 *
 *
 *
 */

#include <Xm/Xm.h>
#include "mx_locked_d.h"

#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/Separator.h>
#include <Xm/Protocols.h>

static void button_cb(
            Widget    widget, 
            XtPointer client_data, 
            XtPointer call_data)
{
    mx_locked_d *d = (mx_locked_d*)client_data;

    if (widget == d->confirm_button)
    {
        d->modal_result = yes_e;
    }
}

mx_locked_d::mx_locked_d(Widget parent) : mx_dialog("locked", parent, TRUE, FALSE)
{
    Widget   pixmap_label, label1, label2, label3, label4, label5, label6, label7;

    XtVaSetValues(action_area, XmNfractionBase, 3, NULL);

    pixmap_label = XtVaCreateManagedWidget(
                "pixmap",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,  XmATTACH_FORM,
                XmNleftAttachment, XmATTACH_FORM,
                NULL);

    label1 = XtVaCreateManagedWidget(
                "text1",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,  XmATTACH_FORM,
                XmNleftAttachment, XmATTACH_WIDGET,
                XmNleftWidget, pixmap_label,
                NULL);

    label2 = XtVaCreateManagedWidget(
                "text2",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,  XmATTACH_WIDGET,
                XmNtopWidget,      label1,
                XmNleftAttachment, XmATTACH_WIDGET,
                XmNleftWidget, pixmap_label,
                NULL);

    label3 = XtVaCreateManagedWidget(
                "text3",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,  XmATTACH_WIDGET,
                XmNtopWidget,      label2,
                XmNleftAttachment, XmATTACH_WIDGET,
                XmNleftWidget, pixmap_label,
                NULL);

    label4 = XtVaCreateManagedWidget(
                "text4",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,  XmATTACH_WIDGET,
                XmNtopWidget,      label3,
                XmNleftAttachment, XmATTACH_WIDGET,
                XmNleftWidget, pixmap_label,
                NULL);

    label5 = XtVaCreateManagedWidget(
                "text5",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,  XmATTACH_WIDGET,
                XmNtopWidget,      label1,
                XmNleftAttachment, XmATTACH_WIDGET,
                XmNleftWidget,     label2,
                NULL);

    label6 = XtVaCreateManagedWidget(
                "text6",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,  XmATTACH_WIDGET,
                XmNtopWidget,      label5,
                XmNleftAttachment, XmATTACH_WIDGET,
                XmNleftWidget,     label2,
                NULL);

    label7 = XtVaCreateManagedWidget(
                "text6",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,  XmATTACH_WIDGET,
                XmNtopWidget,      label6,
                XmNleftAttachment, XmATTACH_WIDGET,
                XmNleftWidget,     label2,
                NULL);


    file_name_label = label5;
    locked_by_label = label6;
    locked_host_label = label7;

    // now, the action buttons
    confirm_button = XtVaCreateManagedWidget(
                "confirm",
                xmPushButtonGadgetClass, action_area,
                XmNshowAsDefault, True,
                XmNdefaultButtonShadowThickness, 1,
                XmNleftAttachment,   XmATTACH_POSITION,
                XmNleftPosition,     1,
                XmNrightAttachment,  XmATTACH_POSITION,
                XmNrightPosition,     2,
                NULL);

    XtAddCallback(
            confirm_button, 
            XmNactivateCallback, 
            button_cb, 
            (XtPointer)this);

    XtManageChild(action_area);
    XtManageChild(control_area);
    XtManageChild(pane);
}

void mx_locked_d::activate(char *file, char *locked_by, char *locked_host)
{
    XmString str;

    str = XmStringCreate(file, XmFONTLIST_DEFAULT_TAG);
    XtVaSetValues(file_name_label, XmNlabelString, str, NULL);

    str = XmStringCreate(locked_by, XmFONTLIST_DEFAULT_TAG);
    XtVaSetValues(locked_by_label, XmNlabelString, str, NULL);

    str = XmStringCreate(locked_host, XmFONTLIST_DEFAULT_TAG);
    XtVaSetValues(locked_host_label, XmNlabelString, str, NULL);

    mx_dialog::activate();
}
