/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <mx.h>

void test(int &err, int test_num)
{
    switch(test_num)
    {
    case 0:
        MX_ERROR_ASSERT(err, 0 == 1);
        break;
    case 1:
        MX_ERROR_ASSERT(err, 0 == 0);
        break;
    case 2:
        MX_ERROR_ASSERT(err, TRUE);
        break;
    case 3:
        MX_ERROR_ASSERT(err, FALSE);
        break;
    default:
        break;
    }
abort:;
}

int main()
{
    int err = MX_ERROR_OK;

    for(int i = 0; i < 4; i++)
    {
        test(err, i);
        MX_ERROR_CHECK(err);
    abort:
        global_error_trace->print();
        MX_ERROR_CLEAR(err);
    }
    return EXIT_SUCCESS;
}


