/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <mx.h>
#include <geometry.h>

void testSpan()
{
    mx_rect s(0,0,10,10,FALSE,FALSE);
    mx_snap_info si(FALSE) ;
    mx_point testPoint ;
    double distVal ;
    
    testPoint.x = 0 ;
    testPoint.y = 0 ;
    
    do
    {
	distVal = s.dist2snap(testPoint,si,GEOM_SMALL) ;
    } while (si.getCount() != MX_GEOM_SNAP_NONE) ;

}

void testArc()
{
  mx_point c(0,0) ;
  mx_point s(10,10) ;
  double   angle1 = 0 ;
  double   angle2 = PITWO ;
  double   distVal ;

  ARC_TYPE at = ARC_ARC ;
  mx_snap_info si(FALSE,20)  ;
  mx_point testPoint ;


  mx_arc a(c,s,angle1,angle2,at) ;


  testPoint.x = 0 ;
  testPoint.y = 0 ;

  do
  {
    distVal = a.dist2snap(testPoint,si,GEOM_SMALL) ;
  } while (si.getCount() != MX_GEOM_SNAP_NONE) ;
}


main()
{
  //    testSpan() ;
    
  testArc() ;

  return 0 ;

#ifdef fffsfsfdfasff

   mx_point p1(3,4) ;
   mx_point p2(3.3,4.7) ;
   mx_ipoint ip1(3.3,2.1);
   mx_ipoint ip2(3,4) ;

   p2+=p1 ;
   p2-=p1 ;
   p2*=3.4 ;
   p2/=3.4 ;

   /*
   p2 = ip1 + p1 ;
   p2 = ip1 - p1 ;
   p2 = p1/2.3 ;
   p2 = 5*p1;
   p2 = p1*5 ;
   */

   ip2+=p1 ;
   ip2-=p1 ;
   ip2*=3.4 ;
   ip2/=3.4 ;

   /*
   ip2 = ip1 + p1 ;
   ip2 = ip1 - p1 ;
   ip2 = p1/2.3 ;
   ip2 = 5*p1;
   ip2 = p1*5 ;
   */

   double ty,sy,by ;

   ty = p1*p2 ;

   sy = p1^p2 ;

   by = ty + sy ;

   int   err ;
   mx_geom *geom0,*geom1,*geom2,*geom3,*geom4,*geom5,*geom6,*geom7,*geom8,*geom9 ;

   mx_geom *geom10,*geom11,*geom12,*geom13,*geom14,*geom15,*geom16,*geom17,*geom18,*geom19 ;
   mx_geom *geom20,*geom21,*geom22,*geom23,*geom24,*geom25,*geom26,*geom27,*geom28,*geom29 ;

   mx_point ptest01(0.5,0.5) ;
   mx_point ptest02(0.0,1.0) ;
   intersect(err,ptest01,ptest02,&geom0) ;

   mx_point ptest111(0.5,0.5) ;
   mx_point ptest121(0.5,0.5) ;
   intersect(err,ptest111,ptest121,&geom1) ;

   mx_point ptest21(0.5,0.5) ;
   mx_point ptest22(0.50000001,0.500000001) ;
   intersect(err,ptest21,ptest22,&geom2) ;

   mx_point ptest4(0.0,0.0) ;
   mx_rect  rtest4(0,0,1,1) ;
   intersect(err,ptest4,rtest4,&geom4) ;

   mx_point ptest5(0.5,0.5) ;
   mx_rect  rtest5(0,0,1,1) ;
   intersect(err,ptest5,rtest5,&geom5) ;

   mx_point ptest6(1.0000001,1.00000001) ;
   mx_rect  rtest6(0,0,1,1) ;
   intersect(err,ptest6,rtest6,&geom6) ;

   mx_point ptest7(0.5,0.5) ;
   mx_rect  rtest7(0,0,1,1,TRUE) ;
   intersect(err,ptest7,rtest7,&geom7) ;

   mx_point ptest8(1.0000001,1.00000001) ;
   mx_rect  rtest8(0,0,1,1,TRUE) ;
   intersect(err,ptest8,rtest8,&geom8) ;

   mx_point ptest9(1.5,1.5) ;
   mx_rect  rtest9(0,0,1,1,TRUE) ;
   intersect(err,ptest9,rtest9,&geom9) ;

   mx_point ptest10(0.3,0.3) ;
   mx_rect  rtest10(0,0,1,1,TRUE) ;
   intersect(err,ptest10,rtest10,&geom10) ;

   mx_point ptest11(0.5001,0.5001) ;
   mx_rect  rtest11(0,0,1,1,TRUE) ;
   intersect(err,ptest11,rtest11,&geom11) ;

   mx_rect rtest121(0,0,1,1) ;
   mx_rect rtest122(1,1,2,3) ;
   intersect(err,rtest121,rtest122,&geom12) ;

   mx_rect rtest131(0,0,1,1) ;
   mx_rect rtest132(0.3,1,0.6,1) ;
   intersect(err,rtest131,rtest132,&geom13) ;

   mx_rect rtest141(0,0,1,1) ;
   mx_rect rtest142(0.5,0.5,1.5,1.5) ;
   intersect(err,rtest141,rtest142,&geom14) ;

   mx_rect rtest151(0,0,1,1,TRUE) ;
   mx_rect rtest152(1,0,0,1,TRUE) ;
   intersect(err,rtest151,rtest152,&geom15) ;

   mx_rect rtest161(0,0,1,1,TRUE) ;
   mx_rect rtest162(1,1,2,2,TRUE) ;
   intersect(err,rtest161,rtest162,&geom16) ;

   mx_rect rtest171(0,0,1,1,TRUE) ;
   mx_rect rtest172(0,0,0.5,0.5,TRUE) ;
   intersect(err,rtest171,rtest172,&geom17) ;

   mx_rect rtest181(0,0,1,1,TRUE) ;
   mx_rect rtest182(0,0,1,1) ;
   intersect(err,rtest181,rtest182,&geom18) ;

   mx_rect rtest191(1,0,1,1,TRUE) ;
   mx_rect rtest192(0,0,1,1) ;
   intersect(err,rtest191,rtest192,&geom19) ;

   mx_rect rtest201(-1.0,-1.0,2.0,2.0,TRUE) ;
   mx_rect rtest202(0,0,1,1) ;
   intersect(err,rtest201,rtest202,&geom20) ;

   mx_rect rtest211(-1.0,-1.0,2.0,2.0,TRUE) ;
   mx_rect rtest212(0,0,1,1) ;
   intersect(err,rtest211,rtest212,&geom21) ;

   mx_rect rtest221(0.5,0.5,2.0,2.0,TRUE) ;
   mx_rect rtest222(0,0,1,1) ;
   intersect(err,rtest221,rtest222,&geom22) ;

   mx_rect rtest231(-0.5,-0.5,0.5,0.5,TRUE) ;
   mx_rect rtest232(0,0,1,1) ;
   intersect(err,rtest231,rtest232,&geom23) ;

   mx_rect rtest241(-1.0,0.0,1,2,TRUE) ;
   mx_rect rtest242(0,0,1,1) ;
   intersect(err,rtest241,rtest242,&geom24) ;

   mx_rect rtest251(-1.0,0.0,0,1,TRUE) ;
   mx_rect rtest252(0,0,1,1) ;
   intersect(err,rtest251,rtest252,&geom25) ;

   mx_rect rtest261(0.0,0.0,5,5,TRUE) ;
   mx_rect rtest262(0,0,1,1) ;
   intersect(err,rtest261,rtest262,&geom26) ;

   return 0;
#endif
}

