/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE/CLASS : set.h
 *
 * AUTHOR : David Miller
 *
 * file 
 *
 * DESCRIPTION:
 * Module set.h
 * 
 *
 *
 */

#ifndef SET_H
#define SET_H

#include "collection.h"


/*-------------------------------------------------
 * CLASS: set
 *
 * DESCRIPTION: A set collection. A set collection
 *              is a set of data where the data is the  
 *              key 
 */

class set:public tree_collection
{
public:
   set(mx_attribute_type keytype) ;

   // Add a new element to the set                         
   bool add( int                &err,
         mx_attribute_value &key_data) ;

   // Remove an element from the set
   bool remove(int                &err,
           mx_attribute_value &key_data) ;

} ;   


/*-------------------------------------------------
 * FUNCTION: set::add
 *
 * DESCRIPTION: set::add - add an element to a set
 *              if data count is returned as 1 then             
 *              the element previously existed in the       
 *              in the set 
 */ 

inline bool set::add(int                &err,
             mx_attribute_value &key_data) 
{
   int data_count ;

   t.add(err,key_data,key_data,data_count) ;
   MX_ERROR_CHECK(err) ;

   if(data_count == 0) 
   {
      nelements++ ;
      return TRUE ;
   }
   else
   {
      return FALSE ;
   }

  abort:
   return FALSE ;
}


/*-------------------------------------------------
 * FUNCTION: set::remove
 *
 * DESCRIPTION: set::remove. Remove an element from 
 *              a set.         
 *
 */

inline bool set::remove(int                &err,
            mx_attribute_value &key_data) 
{
   int data_count ;

   t.remove(err,key_data,data_count,FALSE) ;
   MX_ERROR_CHECK(err) ;

   if(data_count == 1) 
   {
      nelements-- ; 
      return TRUE ;
   }
   else
   {
      return FALSE ;
   }

  abort:
   return FALSE ;
}

#endif
      
