/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE/CLASS : node.h
 *
 * AUTHOR : David Miller
 *
 * 
 *
 * DESCRIPTION:
 * Module node.h
 *
 *
 *
 */

#ifndef NODE_H
#define NODE_H

#include <stdio.h>
#include <stdlib.h>
#include "mx_attribute.h"

typedef enum
{
   NODE_BLACK,
   NODE_RED 
} NODE_COLOUR ;


/*-------------------------------------------------
 * CLASS: node
 *
 * DESCRIPTION: A node in a tree
 * 
 *
 */

class node
{
   friend class tree ; 
   friend class iterator ; 

   mx_attribute_value     data ;
   mx_attribute_value     key ;
   node                   *parent ;
   node                   *left ;
   node                   *right ;
   unsigned char          colour ;
   int                    count ;    

public:

   node(node *p,bool add_right) ;
   node() ;

private: 
   void left_rotate(node **new_root) ;
   void right_rotate(node **new_root) ;
} ;



/*-------------------------------------------------
 * FUNCTION: node::left_rotate
 *
 * DESCRIPTION: Do a left rotation as part of a
 * rebalancing act
 *
 */

inline void node::left_rotate(node **new_root)
{
   node *old_right,*old_right_left ;
   
   /* Get right node of the node to rotate around */

   old_right       = this->right ;

   /* Make right branch of node to be left branch
      of the the old right branch */

   old_right_left = old_right->left ;      
   right          = old_right_left ;
   if(old_right_left != NULL) old_right_left->parent = this ; 

   /* Set the old right branch parent to be the
      nodes parent */

   old_right->parent = parent ;
   
   if(parent == NULL) 
   {
      /* We hav a new root */

      *new_root = old_right ;
   }
   else
   {
      /* Not a new root */
      
      node *parent_left ;

      parent_left = parent->left ;

      if(parent_left == this)
      {
     parent->left   = old_right ;
      }
      else
      {
     parent->right = old_right ;
      }
   }

   /* Put this node on the old rights left */

   old_right->left = this ;
   parent          = old_right ;
   
}



/*-------------------------------------------------
 * FUNCTION: node::right_rotate
 *
 * DESCRIPTION: Do a right rotation as part of a
 * rebalancing act
 *
 */

inline void node::right_rotate(node **new_root)
{
   node *old_left,*old_left_right ;
   
   /* Get left node of the node to rotate around */

   old_left       = this->left ;

   /* Make left branch of node to be right branch
      of the the old left branch */

   old_left_right = old_left->right ;      
   left          = old_left_right ;
   if(old_left_right != NULL) old_left_right->parent = this ; 

   /* Set the old left branch parent to be the
      nodes parent */

   old_left->parent = parent ;
   
   if(parent == NULL) 
   {
      /* We hav a new root */

      *new_root = old_left ;
   }
   else
   {
      /* Not a new root */
      node *parent_right ;

      parent_right = parent->right ;

      if(parent_right == this) 
      {
     parent->right   = old_left ;
      }
      else
      {
     parent->left = old_left ;
      }
   }

   /* Put this node on the old lefts right */

   old_left->right = this ;
   parent          = old_left ;
   
}

#endif
