/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE : mx_list_test.C
 *
 * AUTHOR : Tom Newton
 *
 * This file 
 *
 * DESCRIPTION: 
 * Module mx_list_test.C 
 * 
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <mx_list.h>
#include <mx_list_iter.h>


void test_iter(int &err)
{
    mx_list l;
    int i;
    mx_list_iterator iter(l);

    for (i = 0; i < 10; i++)
    {
        l.append((void *)i); 
        MX_ERROR_CHECK(err);
    }

    iter.rewind();

    while (iter.more())
    {
        i = (int)iter.data();
        printf("i[%d] = %d\n", iter.key(), i);
    }

    printf("-------------------same again backwards\n");
    iter.rewind(mx_backwards_e);

    while (iter.more())
    {
        i = (int)iter.data();
        printf("i[%d] = %d\n", iter.key(), i);
    }

abort:;
}

void leak_test(int &err)
{
    mx_list *l;
    int i;


    while (TRUE)
    {
        l = new mx_list;
        for (i = 0; i < 2000; i++)
        {
            l->append(NULL);
        }
        for (i = 0; i < 2000; i++)
        {
            l->remove(err, 0);
            MX_ERROR_CHECK(err);
        }
        delete l;
    }
abort:;
}

// time to create/delete a list of 1000 nodes 10000 times
void timing_test(int &err)
{
    mx_list l;
    for(int i = 0; i < 10000; i++)
    {
        for(int j = 0; j < 1000; j++)
        {
            l.append((void *)j);
        }
        for(int j = 0; j < 1000; j++)
        {
            l.remove(err, 0);
        }
    }
}

int main()
{
    int i, err = MX_ERROR_OK;

    printf("test iterator.............1\n");
    printf("leak test.................2\n");
    printf("timing test...............3\n");

    printf("which>");
    scanf("%d", &i);

    switch (i)
    {
        case 1 :
            test_iter(err);
            MX_ERROR_CHECK(err);
            break;
        case 2 :
            leak_test(err);
            break;
        case 3 :
            timing_test(err);
            break;
    }

    return 0;
abort:
    global_error_trace->print();
    return -1;
}
