/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE/CLASS : dictionary.h
 *
 * AUTHOR : David Miller
 *
 * 
 *
 * DESCRIPTION:
 * Module dictionary.h
 * 
 * 
 * 
 *
 * $header$
 * $log$
 *
 */

#ifndef DICTIONARY_H
#define DICTIONARY_H

#include "collection.h"


/*-------------------------------------------------
 * CLASS: dictionary
 *
 * DESCRIPTION: Class to provide a dictionary -that 
 *              is a key and a data item. If the key is  
 *              the data use a set (for unique entries) 
 *              or a bag for multiple entries
 *   
 * dictionary is derived from a tree collection - a
 * collection based on a balanced binary tree.
 *
 */

class dictionary:public tree_collection
{
public:
   dictionary(mx_attribute_type keytype,mx_attribute_type datatype) ;

   // Add a new element to the dictionary                         
   void add( int                &err,
         mx_attribute_value &key_data,
         mx_attribute_value &data,
         int                &data_count) ;

   // Remove an element from the dictionary
   bool remove(int                &err,
           mx_attribute_value &key_data) ;

   // Get an element in the dictionary type only
   bool get( int                &err,
         mx_attribute_value &key_data,
         mx_attribute_value &data) ;

} ;   


/*-------------------------------------------------
 * FUNCTION: dictionary::add
 *
 * DESCRIPTION: Add a new element to the dictionary 
 *              Here key is the key for the data,
 *              data the set to be stored and data_count                    
 *              is zero if the record does not exist in
 *              the dictionary, 1 if the record already
 *              exists (matching key and data) and -1 
 *              if the key matches but the data does not              
 */              

inline void dictionary::add(int                &err,
                mx_attribute_value &key_data,
                mx_attribute_value &data,
                int                &data_count)
{
   /* Simple key add */

   t.add(err,key_data,data,data_count) ;
   MX_ERROR_CHECK(err) ;

   /* If we have added a new element increment the count 
      on the collection */

   if(data_count == 0) nelements++ ;

  abort:
   return ;
}

/*-------------------------------------------------
 * FUNCTION: dictionary::remove
 *
 * DESCRIPTION: Remove an element in the dictionary 
 *              Here key is the key for the data,
 *              The program returns true if it found
 *              an element to delete - else FALSE
 */              

inline bool dictionary::remove(int                &err,
                   mx_attribute_value &key_data) 
{
   int   data_count ;

   /* simple remove from tree */
   t.remove(err,key_data,data_count,FALSE) ;
   MX_ERROR_CHECK(err) ;

   /* If we have removed an element then decrement count */
   if(data_count == 1) 
   {
      return TRUE ;
      nelements-- ;
   }
   else
   {
      return FALSE ;
   }

  abort:
   return FALSE ;
}

/*-------------------------------------------------
 * FUNCTION: dictionary::get
 *
 * DESCRIPTION: Get an element in the dictionary 
 *              Here key is the key for the data,
 *              and data the retrieved data.
 *              
 *              exist in table but if it is  1 a  record 
 *              has been found
 */              

inline bool dictionary::get(int                &err,
                mx_attribute_value &key_data,
                mx_attribute_value &data) 
{
   int data_count ;

   /* get data from the tree */

   t.get(err,key_data,data,data_count) ;
   MX_ERROR_CHECK(err) ;

   goto exit ;

  abort:
   return 0 ;
  exit:
   return (data_count == 1) ;
}

      
#endif 
