/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE/CLASS : bag.h
 *
 * AUTHOR : David Miller
 *
 * 
 *
 * DESCRIPTION:
 * Module bag.h
 * 
 * 
 * 
 *
 * $header$
 * $log$
 *
 */

#ifndef BAG_H
#define BAG_H

#include "collection.h"


/*-------------------------------------------------
 * CLASS: bag
 *
 * DESCRIPTION: Bag class - based on a tree with 
 *              a single key item, but allowing multiple          
 *              entries.
 */



class bag:public tree_collection
{
public:
   bag(mx_attribute_type keytype) ;

   // Add a new element to the bag                         
   int   add(int                &err,
         mx_attribute_value &key_data) ;


   // Remove an element from the bag
   int   remove(int                &err,
            mx_attribute_value &key_data,
            bool               force_delete = FALSE) ;
} ;   


/*-------------------------------------------------
 * FUNCTION: bag::add
 *
 * DESCRIPTION: Add a new element to the bag. Returns
 *              the number of elements prior to adding the        
 *              entry
 */

inline int   bag::add(int                &err,
              mx_attribute_value &key_data) 
{
   int   data_count ;

   t.add(err,key_data,key_data,data_count) ;
   MX_ERROR_CHECK(err) ;

   if(data_count == 0) nelements++ ;

   return data_count ;
  abort:
   return 0 ;
}


/*-------------------------------------------------
 * FUNCTION: bag::remove
 *
 * DESCRIPTION: Remove an element from a bag. Returns
 *              the number of elements prior to the      
 *              deletion. Deletion can be forced (i.e.
 *              an element actually deleted not just
 *              reference count decremented) by setting
 *              the force delete flag
 */

inline int   bag::remove(int                &err,
             mx_attribute_value &key_data,
             bool               force_delete) 
{
   int   data_count ;

   t.remove(err,key_data,data_count,force_delete) ;
   MX_ERROR_CHECK(err) ;
   if(data_count > 0) nelements-- ; 

   return data_count ;
  abort:
   return 0 ;
}

#endif
      
