#
# This file is part of the Maxwell Word Processor application.
# Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#



TARGET_ALL       := $(addsuffix .All,        $(addprefix  $(MAXUSERROOT)/$(MODULE)/, $(COMPONENTS))) 
TARGET_CLEAN     := $(addsuffix .Clean,      $(addprefix  $(MAXUSERROOT)/$(MODULE)/, $(COMPONENTS))) 
TARGET_SRC       := $(addsuffix .Src,        $(addprefix  $(MAXUSERROOT)/$(MODULE)/, $(COMPONENTS))) 
TARGET_CLEANSRC  := $(addsuffix .CleanSrc,   $(addprefix  $(MAXUSERROOT)/$(MODULE)/, $(COMPONENTS))) 
TARGET_INCLUDE   := $(addsuffix .Include,    $(addprefix  $(MAXUSERROOT)/$(MODULE)/, $(COMPONENTS))) 

SHELL   := /bin/csh

.PHONY : all   
.PHONY : clean 
.PHONY : src   
.PHONY : clearsrc
.PHONY : include

all: $(TARGET_INCLUDE) $(TARGET_ALL)  

src: $(TARGET_SRC) 

clean: $(TARGET_CLEAN) 

cleansrc: $(TARGET_CLEANSRC)

include: $(TARGET_INCLUDE)

$(MAXUSERROOT)/%.Src :
	if(! -e $(basename $@)) mkdir $(basename $@) ; cd $(basename $@) ;  if(! -l RCS) ln -s $(MAXROOT)/rcs/$(MODULE)/$(notdir $(basename $@)) RCS ; if(! -w Makefile) rm -f  Makefile && $(MAKE) $(MFLAGS) src

$(MAXUSERROOT)/%.Clean :
	cd $(basename $@) && $(MAKE) $(MFLAGS) clean

$(MAXUSERROOT)/%.CleanSrc :
	cd $(basename $@) && $(MAKE) $(MFLAGS) cleansrc
	-$(MAXUSERROOT)/build/rcsclean Makefile

$(MAXUSERROOT)/%.Include :
	cd $(basename $@) && $(MAKE) $(MFLAGS) include

$(MAXUSERROOT)/%.All :
	cd $(basename $@) && $(MAKE) $(MFLAGS) all 

		  



