#
# This file is part of the Maxwell Word Processor application.
# Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#


OBJECTS                  := $(subst .C,.o, $(SOURCES))
TMPDIR	                 := $(MAXUSERROOT)/tmp
OBJDIR                   := $(MAXUSERROOT)/build/obj
INCDIR	                 := $(MAXUSERROOT)/include
DEPENDS                  := $(addprefix $(TMPDIR)/, $(subst .C,.d, $(SOURCES)))
CLEAN_OBJECTS            := $(addprefix $(TMPDIR)/, $(OBJECTS))
PUBLIC_HEADER_TARGETS    := $(addprefix $(INCDIR)/, $(PUBLIC_HEADERS)) 

EXTRA_FULL_EXECS         := $(addprefix $(MAXUSERROOT)/exe/, $(EXTRA_EXECS))
PURIFY_EXECS             := $(addprefix $(MAXUSERROOT)/exe/pure-, $(subst .C,, $(EXEC_SOURCES)))
EXECS			 := $(addprefix $(MAXUSERROOT)/exe/, $(subst .C,, $(EXEC_SOURCES)))
EXEC_OBJECTS             := $(addprefix $(MAXUSERROOT)/tmp/, $(subst .C,.o, $(EXEC_SOURCES)))
EXEC_DEPENDS             := $(subst .o,.d,$(EXEC_OBJECTS))

ifeq ($(USER_ENV_CFLAGS),)
	USER_ENV_CFLAGS := -g
endif

CFLAGS            := -pipe -Wall -c -MD -I$(INCDIR) -I. \
                     -I$(MAXROOT)/$(HOSTTYPE)/include -I/usr/X11R6/include/ \
                     -I/usr/include/X11 $(USER_ENV_CFLAGS) $(USER_CFLAGS) \
                     -Wno-unused

LIBRARY           := $(MAXUSERROOT)/lib/lib$(MODULE).a
LIBRARY_OBJECTS   := ${addsuffix ), ${addprefix ${LIBRARY}(,${OBJECTS}}}
SHELL             := /bin/csh

EXEC_LNLIBS       := $(addsuffix .a, $(addprefix $(MAXUSERROOT)/lib/lib, \
                     $(EXEC_MODULES)))
EXEC_LNOPTS       := -pipe -L$(MAXROOT)/$(HOSTTYPE)/lib -lc $(USER_LNOPTS) \
                     -L/usr/X11/lib
LNCFLAGS          := $(EXEC_LNLIBS) $(EXEC_LNOPTS)

.PHONY : all
.PHONY : clean
.PHONY : include 
.PHONY : src
.PHONY : cleansrc
.PHONY : exec
.PHONY : purify
.PHONY : extra

all: include $(LIBRARY)

.PRECIOUS : $(LIBRARY) 
.PRECIOUS : $(EXECS)
.PRECIOUS : $(EXTRA_EXECS)

$(LIBRARY): $(LIBRARY_OBJECTS) 
	ranlib $(LIBRARY)

$(LIBRARY)(%) : $(TMPDIR)/%
	ar rv $(LIBRARY) $<
	rm -f $<

$(TMPDIR)/%.o : %.C
	$(SILENT) $(CC) $(CFLAGS) -o $@ $<  
	$(MAXUSERROOT)/build/movedep $(subst .C,.d, $<) $(LIBRARY)

include: $(PUBLIC_HEADER_TARGETS)

$(INCDIR)/%.h : %.h
	cp -f $< $@

exec: include $(LIBRARY) $(EXECS)


purify: include $(LIBRARY) $(PURIFY_EXECS)


$(EXECS) : $(EXEC_OBJECTS) $(EXEC_LNLIBS)
	$(SILENT) $(CC) -o $@ $< $(LNCFLAGS)

$(PURIFY_EXECS) : $(EXEC_OBJECTS) $(EXEC_LNLIBS)
	$(SILENT) purify $(CC) -o $@ $< $(LNCFLAGS)

$(EXEC_OBJECTS) : $(EXEC_SOURCES)
	$(SILENT) $(CC) $(CFLAGS) -o $@ $<
	-echo -n $(TMPDIR)/ | cat - $(subst .C,.d,$<) > $(subst .o,.d,$@) 
	-rm $(subst .C,.d,$<) 

extra: include $(LIBRARY) $(EXTRA_FULL_EXECS)

$(MAXUSERROOT)/exe/%:
	$(MAKE) -f Makefile.$(notdir $@)  'COMPONENT=$(COMPONENT)' 'DOCOCOMMAND=y' src
	$(MAKE) -f Makefile.$(notdir $@)  'COMPONENT=$(COMPONENT)' exec

clean:
	-rm -f $(EXECS) $(EXEC_OBJECTS) $(EXEC_DEPENDS) $(DEPENDS) \
	       $(CLEAN_OBJECTS) $(LIBRARY) $(PUBLIC_HEADER_TARGETS) 

cleansrc:
	-$(MAXUSERROOT)/build/rcsclean $(SOURCES) $(EXEC_SOURCES) $(PUBLIC_HEADERS) $(PRIVATE_HEADERS) $(OTHER_FILES) Makefile

src: $(SOURCES) $(EXEC_SOURCES) $(PUBLIC_HEADERS) $(PRIVATE_HEADERS) $(OTHER_FILES) 

%::RCS/%,v
ifdef DOCOCOMMAND
	co -q  $@ 
else
# do nothing
endif 

-include $(EXEC_DEPENDS) /dev/null
-include $(DEPENDS) /dev/null
