/*
 * utilsty.h
 *
 * Some routines to deal with style sheets
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97 Akim Demaille, Miguel Santana
 * $Id: utilsty.h,v 1.1.2.2 1997/06/28 12:54:31 demaille Exp $
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _UTILSTY_H
#define _UTILSTY_H

#include "styles.h"
struct print_job;

/************************************************************************/
/*				style selection				*/
/************************************************************************/
STYLE guess_with_rules PARAMS ((struct print_job * job, char * filename));

/*
 * Return the index of the language which has STRING as name or abbrev.
 * Return plain_style if none
 */
STYLE select_style PARAMS ((char *string));
STYLE guess_language PARAMS ((struct print_job * job, char *filename));

/*
 * Strings that are strcmp tested, plus, if at_start, the need
 * to be at the start of a line, or/and if at_end, at the end of line
 */
typedef struct matching_string {
  ustring string;
  FACE font;
  int at_start;
  int at_end;
} matching_string;

typedef struct matching_sequence {
  matching_string open;
  FACE in_font;
  int nb; 		/* Number of closing alternatives */
  matching_string * close;
} matching_sequence ; 

/* Routines on the keywords (comparison, sorting) */
int keywordCmp PARAMS((const void * k1, const void * k2));
int keywordnCmp PARAMS((const void * keyval, const void * datum));
int sort_keywords PARAMS((keyword ** dest, STYLE style, int min[256], int max[256]));

/* Routines on the symbols (regular and special) (comparison, sorting) */
int symbolCmp PARAMS((const void * k1, const void * k2));
int symbolnCmp PARAMS((const void * keyval, const void * datum));
int sort_regulars PARAMS((symbol ** dest, STYLE style, int min[256], int max[256]));
int sort_specials PARAMS((symbol ** dest, STYLE style, int min[256], int max[256]));

/* On the sequences */
int set_sequences PARAMS((matching_sequence ** dest, STYLE style));

#endif /* no _STYLE_UTILS_H */
